/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag.view;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.drag.view.DragViewHandler;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import java.awt.Point;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;

public abstract class ComponentDragViewHandler<C extends JComponent, T>
implements DragViewHandler<T> {
    @Nullable
    protected Point location;
    @Nullable
    protected WeakReference<C> reference;

    @Override
    @NotNull
    public BufferedImage getView(@NotNull T object, @NotNull DragSourceDragEvent event) {
        C component2 = this.getComponent(object, event);
        if (this.reference == null || this.reference.get() != component2) {
            this.reference = new WeakReference<C>(component2);
        }
        return this.createComponentView(component2);
    }

    @NotNull
    protected BufferedImage createComponentView(@NotNull C component2) {
        return SwingUtils.createComponentSnapshot(component2, this.getSnapshotOpacity());
    }

    public float getSnapshotOpacity() {
        return 0.8f;
    }

    @Override
    @NotNull
    public Point getViewRelativeLocation(@NotNull T object, DragSourceDragEvent event, @NotNull BufferedImage view) {
        if (this.location == null) {
            C component2 = this.getComponent(object, event);
            this.location = this.calculateViewRelativeLocation(component2, event);
        }
        return this.location;
    }

    @NotNull
    protected Point calculateViewRelativeLocation(@NotNull C component2, @NotNull DragSourceDragEvent event) {
        Point los = CoreSwingUtils.locationOnScreen(component2);
        Point eloc = event.getLocation();
        return new Point(los.x - eloc.x, los.y - eloc.y);
    }

    @Override
    public void dragEnded(@NotNull T object, @NotNull DragSourceDropEvent event) {
        this.location = null;
        this.reference = null;
    }

    @NotNull
    public abstract C getComponent(@NotNull T var1, @NotNull DragSourceDragEvent var2);
}

