/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag.transfer;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class TextDragHandler
extends TransferHandler {
    private String text;
    private boolean defaultBehavior = true;

    public TextDragHandler(JComponent component2) {
        this(component2, null);
    }

    public TextDragHandler(JComponent component2, String text) {
        this(component2, text, true);
    }

    public TextDragHandler(final JComponent component2, String text, boolean defaultBehavior) {
        this.setText(text);
        this.setDefaultBehavior(defaultBehavior);
        component2.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TextDragHandler.this.isDefaultBehavior() && SwingUtilities.isLeftMouseButton(e) && component2.isEnabled()) {
                    TextDragHandler.this.exportAsDrag(component2, e, TextDragHandler.this.getSourceActions(component2));
                }
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isDefaultBehavior() {
        return this.defaultBehavior;
    }

    public void setDefaultBehavior(boolean defaultBehavior) {
        this.defaultBehavior = defaultBehavior;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new StringSelection(this.getText());
    }
}

