/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag.transfer;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.drag.transfer.AbstractTransferHandler;
import com.alee.managers.drag.transfer.FilesTransferable;
import com.alee.utils.CollectionUtils;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class FilesTransferHandler
extends AbstractTransferHandler {
    public FilesTransferHandler(boolean dragEnabled, boolean dropEnabled) {
        super(dragEnabled, dropEnabled);
    }

    @Override
    @Nullable
    protected Transferable createTransferable(@NotNull JComponent component2) {
        List<File> draggedFiles;
        FilesTransferable transferable = this.isDragEnabled() ? ((draggedFiles = this.getDraggedFiles()) != null && draggedFiles.size() > 0 ? new FilesTransferable(draggedFiles) : null) : null;
        return transferable;
    }

    @Nullable
    public File getDraggedFile() {
        return null;
    }

    @Nullable
    public List<File> getDraggedFiles() {
        File file = this.getDraggedFile();
        return file != null ? CollectionUtils.asList(file) : null;
    }

    @Override
    public boolean canImport(@NotNull TransferHandler.TransferSupport support) {
        return this.isDropEnabled() && FilesTransferable.hasFilesList(support.getTransferable());
    }

    @Override
    public boolean importData(@NotNull TransferHandler.TransferSupport info) {
        List<File> files2;
        boolean imported = false;
        if (this.isDropEnabled() && info.isDrop() && CollectionUtils.notEmpty(files2 = FilesTransferable.getFilesList(info.getTransferable()))) {
            imported = this.filesDropped(files2);
        }
        return imported;
    }

    public boolean filesDropped(@NotNull List<File> files2) {
        return true;
    }
}

