/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.transition;

import com.alee.managers.animation.AnimationException;
import com.alee.managers.animation.AnimationManager;
import com.alee.managers.animation.easing.Cubic;
import com.alee.managers.animation.easing.Easing;
import com.alee.managers.animation.framerate.FrameRate;
import com.alee.managers.animation.transition.AbstractTransition;
import com.alee.managers.animation.transition.TransitionState;
import com.alee.managers.animation.types.TransitionType;

public class TimedTransition<V>
extends AbstractTransition<V> {
    protected static final Easing DEFAULT_EASING = new Cubic.InOut();
    protected static final long DEFAULT_DURATION = 360L;
    protected final TransitionType<V> transitionType;
    protected final V start;
    protected final V goal;
    protected final Easing easing;
    protected final long duration;
    protected Long startTime;

    public TimedTransition(V start2, V goal) {
        this(start2, goal, DEFAULT_FRAME_RATE, DEFAULT_EASING, 360L);
    }

    public TimedTransition(V start2, V goal, FrameRate frameRate) {
        this(start2, goal, frameRate, DEFAULT_EASING, 360L);
    }

    public TimedTransition(V start2, V goal, Easing easing) {
        this(start2, goal, DEFAULT_FRAME_RATE, easing, 360L);
    }

    public TimedTransition(V start2, V goal, Long duration) {
        this(start2, goal, DEFAULT_FRAME_RATE, DEFAULT_EASING, duration);
    }

    public TimedTransition(V start2, V goal, Easing easing, Long duration) {
        this(start2, goal, DEFAULT_FRAME_RATE, easing, duration);
    }

    public TimedTransition(V start2, V goal, FrameRate frameRate, Easing easing, Long duration) {
        super(frameRate);
        if (start2 == null) {
            throw new AnimationException("Transition start value cannot be null");
        }
        if (goal == null) {
            throw new AnimationException("Transition goal value cannot be null");
        }
        this.transitionType = AnimationManager.getTransitionType(start2.getClass());
        this.start = start2;
        this.goal = goal;
        this.easing = easing != null ? easing : DEFAULT_EASING;
        this.duration = duration != null ? duration : 360L;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public V getStart() {
        return this.start;
    }

    @Override
    public V getGoal() {
        return this.goal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(long currentFrame) {
        TimedTransition timedTransition = this;
        synchronized (timedTransition) {
            this.reset();
            this.startTime = currentFrame;
            this.setState(TransitionState.playing);
            return Math.min(this.getFrameDelay(), this.getDuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long proceed(long previousFrame, long currentFrame) {
        TimedTransition timedTransition = this;
        synchronized (timedTransition) {
            if (this.getState() == TransitionState.playing) {
                long passedSincePrevStart;
                long transitionStart = this.getStartTime();
                long frameDelay = this.getFrameDelay();
                long frame = transitionStart < previousFrame ? ((passedSincePrevStart = previousFrame - transitionStart) >= frameDelay ? previousFrame + frameDelay - (long)Math.round(passedSincePrevStart % frameDelay) : previousFrame + frameDelay - passedSincePrevStart) : transitionStart + frameDelay;
                if (frame <= currentFrame) {
                    this.fireAdjusted(this.getValue());
                    long duration = this.getDuration();
                    long endFrame = transitionStart + duration;
                    if (endFrame < currentFrame) {
                        this.setState(TransitionState.finished);
                        return endFrame - currentFrame;
                    }
                    long nextFrame = frame + frameDelay;
                    if (endFrame < nextFrame) {
                        return endFrame - currentFrame;
                    }
                    if (nextFrame < currentFrame) {
                        return this.proceed(frame, currentFrame);
                    }
                    return nextFrame - currentFrame;
                }
                return frame - currentFrame;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        TimedTransition timedTransition = this;
        synchronized (timedTransition) {
            if (this.getState() == TransitionState.playing) {
                this.setState(TransitionState.aborted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        TimedTransition timedTransition = this;
        synchronized (timedTransition) {
            if (this.getState() != TransitionState.ready) {
                this.setState(TransitionState.ready);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValue() {
        TimedTransition timedTransition = this;
        synchronized (timedTransition) {
            switch (this.getState()) {
                case playing: {
                    return this.transitionType.value(this.easing, this.start, this.goal, this.getProgress(), this.getTotal());
                }
                case finished: {
                    return this.getGoal();
                }
                case aborted: {
                    return this.getLatest();
                }
            }
            return this.getStart();
        }
    }

    protected double getProgress() {
        long elapsedTime;
        long duration = this.getDuration();
        return duration > (elapsedTime = this.getElapsedTime()) ? (double)elapsedTime / (double)duration : this.getTotal();
    }

    protected double getTotal() {
        return 1.0;
    }

    protected long getTime() {
        return System.nanoTime();
    }

    protected long getDuration() {
        return this.duration * 1000000L;
    }

    protected long getFrameDelay() {
        return Math.round(1.0E9 / this.getFrameRate().value());
    }

    protected long getElapsedTime() {
        return this.getTime() - this.getStartTime();
    }
}

