/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.easing;

import com.alee.managers.animation.easing.AbstractEasing;
import com.thoughtworks.xstream.annotations.XStreamAlias;

public abstract class Bounce
extends AbstractEasing {
    @Override
    public String getTitle() {
        return "Bounce";
    }

    protected final double in(double start2, double distance, double current, double total) {
        return distance - this.out(0.0, distance, total - current, total) + start2;
    }

    protected final double out(double start2, double distance, double current, double total) {
        double d;
        current /= total;
        if (d < 0.36363636363636365) {
            return distance * (7.5625 * current * current) + start2;
        }
        if (current < 0.7272727272727273) {
            return distance * (7.5625 * (current -= 0.5454545454545454) * current + 0.75) + start2;
        }
        if (current < 0.9090909090909091) {
            return distance * (7.5625 * (current -= 0.8181818181818182) * current + 0.9375) + start2;
        }
        return distance * (7.5625 * (current -= 0.9545454545454546) * current + 0.984375) + start2;
    }

    @XStreamAlias(value="Bounce$InOut")
    public static final class InOut
    extends Bounce {
        @Override
        public String getTitle() {
            return super.getTitle() + " InOut";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            if (current < total / 2.0) {
                return this.in(0.0, distance, current * 2.0, total) * 0.5 + start2;
            }
            return this.out(0.0, distance, current * 2.0 - total, total) * 0.5 + distance * 0.5 + start2;
        }
    }

    @XStreamAlias(value="Bounce$Out")
    public static final class Out
    extends Bounce {
        @Override
        public String getTitle() {
            return super.getTitle() + " Out";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            return this.out(start2, distance, current, total);
        }
    }

    @XStreamAlias(value="Bounce$In")
    public static final class In
    extends Bounce {
        @Override
        public String getTitle() {
            return super.getTitle() + " In";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            return this.in(start2, distance, current, total);
        }
    }
}

