/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.window;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.laf.rootpane.WebRootPane;
import com.alee.laf.window.WindowEventMethods;
import com.alee.laf.window.WindowEventMethodsImpl;
import com.alee.laf.window.WindowEventRunnable;
import com.alee.laf.window.WindowMethods;
import com.alee.laf.window.WindowMethodsImpl;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.swing.extensions.ComponentEventRunnable;
import com.alee.utils.swing.extensions.WindowCloseAdapter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JWindow;

public class WebWindow<T extends WebWindow<T>>
extends JWindow
implements Styleable,
WindowEventMethods,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
WindowMethods<T> {
    public static final String FOCUSABLE_WINDOW_STATE_PROPERTY = "focusableWindowState";
    public static final String WINDOW_DECORATION_STYLE_PROPERTY = "windowDecorationStyle";
    public static final String RESIZABLE_PROPERTY = "resizable";
    public static final String ICON_IMAGE_PROPERTY = "iconImage";
    public static final String TITLE_PROPERTY = "title";
    protected boolean closeOnFocusLoss = false;
    protected transient DefaultFocusTracker focusTracker;

    public WebWindow() {
        this(StyleId.auto);
    }

    public WebWindow(@Nullable GraphicsConfiguration gc) {
        this(StyleId.auto, gc);
    }

    public WebWindow(@Nullable Component owner) {
        this(StyleId.auto, owner);
    }

    public WebWindow(@Nullable Window owner) {
        this(StyleId.auto, owner);
    }

    public WebWindow(@Nullable Window owner, @Nullable GraphicsConfiguration gc) {
        this(StyleId.auto, owner, gc);
    }

    public WebWindow(@Nullable Frame owner) {
        this(StyleId.auto, owner);
    }

    public WebWindow(@NotNull StyleId id) {
        this(id, (Frame)null);
    }

    public WebWindow(@NotNull StyleId id, @Nullable GraphicsConfiguration gc) {
        this(id, null, gc);
    }

    public WebWindow(@NotNull StyleId id, @Nullable Component owner) {
        this(id, CoreSwingUtils.getWindowAncestor(owner));
    }

    public WebWindow(@NotNull StyleId id, @Nullable Window owner) {
        this(id, owner, owner != null ? owner.getGraphicsConfiguration() : null);
    }

    public WebWindow(@NotNull StyleId id, @Nullable Window owner, @Nullable GraphicsConfiguration gc) {
        super(owner, gc);
        this.initialize(id);
    }

    public WebWindow(@NotNull StyleId id, @Nullable Frame owner) {
        super(owner);
        this.initialize(id);
    }

    @Override
    protected void windowInit() {
    }

    protected void initialize(@NotNull StyleId id) {
        this.setLocale(JComponent.getDefaultLocale());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
        ProprietaryUtils.checkAndSetPolicy(this);
        this.setFocusable(true);
        this.setFocusableWindowState(true);
        WebLookAndFeel.setOrientation(this);
        this.setStyleId(id);
        this.focusTracker = new DefaultFocusTracker(this.getRootPane(), true){

            @Override
            public boolean isEnabled() {
                return WebWindow.this.closeOnFocusLoss && super.isEnabled();
            }

            @Override
            public void focusChanged(boolean focused) {
                if (this.isEnabled() && !focused) {
                    WebWindow.this.dispose();
                }
            }
        };
        FocusManager.addFocusTracker(this.getRootPane(), this.focusTracker);
    }

    @Override
    protected JRootPane createRootPane() {
        return new WebWindowRootPane();
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
    }

    public List<Component> getFocusableChildren() {
        return this.focusTracker.getFocusableChildren();
    }

    public void addFocusableChild(Component child) {
        this.focusTracker.addFocusableChild(child);
    }

    public void removeFocusableChild(Component child) {
        this.focusTracker.removeFocusableChild(child);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.window;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.getRootPane());
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this.getRootPane(), id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this.getRootPane());
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this.getRootPane());
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this.getRootPane(), skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this.getRootPane(), skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this.getRootPane());
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this.getRootPane(), listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this.getRootPane(), listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this.getRootPane());
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this.getRootPane(), painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this.getRootPane());
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this.getRootPane());
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this.getRootPane());
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this.getRootPane(), enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this.getRootPane());
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this.getRootPane(), margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this.getRootPane(), top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this.getRootPane(), margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this.getRootPane());
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this.getRootPane(), padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this.getRootPane(), top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this.getRootPane(), padding);
    }

    public WRootPaneUI getUI() {
        return (WRootPaneUI)this.getRootPane().getUI();
    }

    public void setUI(WRootPaneUI ui) {
        this.getRootPane().setUI(ui);
    }

    @Override
    public WindowAdapter onClosing(WindowEventRunnable runnable) {
        return WindowEventMethodsImpl.onClosing(this, runnable);
    }

    @Override
    public WindowCloseAdapter onClose(ComponentEventRunnable runnable) {
        return WindowEventMethodsImpl.onClose(this, runnable);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this.getRootPane());
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this.getRootPane(), key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this.getRootPane(), data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this.getRootPane(), key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this.getRootPane());
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this.getRootPane());
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this.getRootPane(), updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this.getRootPane());
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this.getRootPane());
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this.getRootPane());
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this.getRootPane(), configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this.getRootPane(), processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this.getRootPane());
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this.getRootPane());
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this.getRootPane());
    }

    @Override
    public boolean isWindowOpaque() {
        return WindowMethodsImpl.isWindowOpaque(this);
    }

    @Override
    public T setWindowOpaque(boolean opaque) {
        return (T)((WebWindow)WindowMethodsImpl.setWindowOpaque(this, opaque));
    }

    @Override
    public float getWindowOpacity() {
        return WindowMethodsImpl.getWindowOpacity(this);
    }

    @Override
    public T setWindowOpacity(float opacity) {
        return (T)((WebWindow)WindowMethodsImpl.setWindowOpacity(this, opacity));
    }

    @Override
    public T center() {
        return (T)((WebWindow)WindowMethodsImpl.center(this));
    }

    @Override
    public T center(Component relativeTo) {
        return (T)((WebWindow)WindowMethodsImpl.center(this, relativeTo));
    }

    @Override
    public T center(int width, int height) {
        return (T)((WebWindow)WindowMethodsImpl.center(this, width, height));
    }

    @Override
    public T center(Component relativeTo, int width, int height) {
        return (T)((WebWindow)WindowMethodsImpl.center(this, relativeTo, width, height));
    }

    @Override
    public T packToWidth(int width) {
        return (T)((WebWindow)WindowMethodsImpl.packToWidth(this, width));
    }

    @Override
    public T packToHeight(int height) {
        return (T)((WebWindow)WindowMethodsImpl.packToHeight(this, height));
    }

    public class WebWindowRootPane
    extends WebRootPane {
        public WebWindowRootPane() {
            super(StyleManager.getDescriptor(WebWindowRootPane.class).getDefaultStyleId());
        }

        @Override
        @NotNull
        public StyleId getDefaultStyleId() {
            return WebWindow.this.getDefaultStyleId();
        }
    }
}

