/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.window;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.laf.rootpane.WebRootPane;
import com.alee.laf.window.WindowEventMethods;
import com.alee.laf.window.WindowEventMethodsImpl;
import com.alee.laf.window.WindowEventRunnable;
import com.alee.laf.window.WindowMethods;
import com.alee.laf.window.WindowMethodsImpl;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.swing.extensions.ComponentEventRunnable;
import com.alee.utils.swing.extensions.WindowCloseAdapter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;

public class WebDialog<T extends WebDialog<T>>
extends JDialog
implements Styleable,
WindowEventMethods,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
WindowMethods<T> {
    protected boolean closeOnFocusLoss = false;
    protected transient DefaultFocusTracker focusTracker;

    public WebDialog(Component owner) {
        this(StyleId.auto, owner);
    }

    public WebDialog(Component owner, String title) {
        this(StyleId.auto, owner, title);
    }

    public WebDialog() {
        this(StyleId.auto);
    }

    public WebDialog(Frame owner) {
        this(StyleId.auto, owner);
    }

    public WebDialog(Frame owner, boolean modal) {
        this(StyleId.auto, owner, modal);
    }

    public WebDialog(Frame owner, String title) {
        this(StyleId.auto, owner, title);
    }

    public WebDialog(Frame owner, String title, boolean modal) {
        this(StyleId.auto, owner, title, modal);
    }

    public WebDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        this(StyleId.auto, owner, title, modal, gc);
    }

    public WebDialog(Dialog owner) {
        this(StyleId.auto, owner);
    }

    public WebDialog(Dialog owner, boolean modal) {
        this(StyleId.auto, owner, modal);
    }

    public WebDialog(Dialog owner, String title) {
        this(StyleId.auto, owner, title);
    }

    public WebDialog(Dialog owner, String title, boolean modal) {
        this(StyleId.auto, owner, title, modal);
    }

    public WebDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        this(StyleId.auto, owner, title, modal, gc);
    }

    public WebDialog(Window owner) {
        this(StyleId.auto, owner);
    }

    public WebDialog(Window owner, Dialog.ModalityType modalityType) {
        this(StyleId.auto, owner, modalityType);
    }

    public WebDialog(Window owner, String title) {
        this(StyleId.auto, owner, title);
    }

    public WebDialog(Window owner, String title, Dialog.ModalityType modalityType) {
        this(StyleId.auto, owner, title, modalityType);
    }

    public WebDialog(Window owner, String title, Dialog.ModalityType modalityType, GraphicsConfiguration gc) {
        this(StyleId.auto, owner, title, modalityType, gc);
    }

    public WebDialog(StyleId id, Component owner) {
        this(id, owner, null);
    }

    public WebDialog(StyleId id, Component owner, String title) {
        this(id, ProprietaryUtils.getWindowAncestorForDialog(owner), title);
    }

    public WebDialog(StyleId id) {
        this(id, (Frame)null);
    }

    public WebDialog(StyleId id, Frame owner) {
        this(id, owner, false);
    }

    public WebDialog(StyleId id, Frame owner, boolean modal) {
        this(id, owner, null, modal);
    }

    public WebDialog(StyleId id, Frame owner, String title) {
        this(id, owner, title, false);
    }

    public WebDialog(StyleId id, Frame owner, String title, boolean modal) {
        this(id, owner, title, modal, owner != null ? owner.getGraphicsConfiguration() : null);
    }

    public WebDialog(StyleId id, Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        this(id, (Window)(owner == null ? ProprietaryUtils.getSharedOwnerFrame() : owner), title, modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS, gc);
    }

    public WebDialog(StyleId id, Dialog owner) {
        this(id, owner, false);
    }

    public WebDialog(StyleId id, Dialog owner, boolean modal) {
        this(id, owner, null, modal);
    }

    public WebDialog(StyleId id, Dialog owner, String title) {
        this(id, owner, title, false);
    }

    public WebDialog(StyleId id, Dialog owner, String title, boolean modal) {
        this(id, owner, title, modal, owner != null ? owner.getGraphicsConfiguration() : null);
    }

    public WebDialog(StyleId id, Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        this(id, (Window)owner, title, modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS, gc);
    }

    public WebDialog(StyleId id, Window owner) {
        this(id, owner, Dialog.ModalityType.MODELESS);
    }

    public WebDialog(StyleId id, Window owner, Dialog.ModalityType modalityType) {
        this(id, owner, null, modalityType);
    }

    public WebDialog(StyleId id, Window owner, String title) {
        this(id, owner, title, Dialog.ModalityType.MODELESS);
    }

    public WebDialog(StyleId id, Window owner, String title, Dialog.ModalityType modalityType) {
        this(id, owner, title, modalityType, owner != null ? owner.getGraphicsConfiguration() : null);
    }

    public WebDialog(StyleId id, Window owner, String title, Dialog.ModalityType modalityType, GraphicsConfiguration gc) {
        super(owner, UILanguageManager.getInitialText(title, new Object[0]), modalityType, gc);
        this.initialize(owner, id, title);
    }

    @Override
    protected void dialogInit() {
    }

    protected void initialize(Window owner, StyleId id, String title) {
        if (owner == ProprietaryUtils.getSharedOwnerFrame()) {
            this.addWindowListener(ProprietaryUtils.getSharedOwnerFrameShutdownListener());
        }
        this.enableEvents(72L);
        this.setLocale(JComponent.getDefaultLocale());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
        ProprietaryUtils.checkAndSetPolicy(this);
        WebLookAndFeel.setOrientation(this);
        this.setDefaultCloseOperation(2);
        this.setStyleId(id);
        if (title != null) {
            UILanguageManager.registerInitialLanguage(this, title, new Object[0]);
        }
        this.focusTracker = new DefaultFocusTracker(this.getRootPane(), true){

            @Override
            public boolean isEnabled() {
                return WebDialog.this.closeOnFocusLoss && super.isEnabled();
            }

            @Override
            public void focusChanged(boolean focused) {
                if (this.isEnabled() && !focused) {
                    WebDialog.this.processWindowEvent(new WindowEvent(WebDialog.this, 201));
                }
            }
        };
        FocusManager.addFocusTracker(this.getRootPane(), this.focusTracker);
    }

    @Override
    protected JRootPane createRootPane() {
        return new WebDialogRootPane();
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
    }

    public List<Component> getFocusableChildren() {
        return this.focusTracker.getFocusableChildren();
    }

    public void addFocusableChild(Component child) {
        this.focusTracker.addFocusableChild(child);
    }

    public void removeFocusableChild(Component child) {
        this.focusTracker.removeFocusableChild(child);
    }

    public boolean isDisplayTitleComponent() {
        return this.getUI().isDisplayTitleComponent();
    }

    public void setDisplayTitleComponent(boolean display) {
        this.getUI().setDisplayTitleComponent(display);
    }

    public JComponent getTitleComponent() {
        return this.getUI().getTitleComponent();
    }

    public void setTitleComponent(JComponent title) {
        this.getUI().setTitleComponent(title);
    }

    public boolean isDisplayWindowButtons() {
        return this.getUI().isDisplayWindowButtons();
    }

    public void setDisplayWindowButtons(boolean display) {
        this.getUI().setDisplayWindowButtons(display);
    }

    public boolean isDisplayMinimizeButton() {
        return this.getUI().isDisplayMinimizeButton();
    }

    public void setDisplayMinimizeButton(boolean display) {
        this.getUI().setDisplayMinimizeButton(display);
    }

    public boolean isDisplayMaximizeButton() {
        return this.getUI().isDisplayMaximizeButton();
    }

    public void setDisplayMaximizeButton(boolean display) {
        this.getUI().setDisplayMaximizeButton(display);
    }

    public boolean isDisplayCloseButton() {
        return this.getUI().isDisplayCloseButton();
    }

    public void setDisplayCloseButton(boolean display) {
        this.getUI().setDisplayCloseButton(display);
    }

    public JComponent getButtonsPanel() {
        return this.getUI().getButtonsPanel();
    }

    public boolean isDisplayMenuBar() {
        return this.getUI().isDisplayMenuBar();
    }

    public void setDisplayMenuBar(boolean display) {
        this.getUI().setDisplayMenuBar(display);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return JDialog.isDefaultLookAndFeelDecorated() ? StyleId.dialogDecorated : StyleId.dialog;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.getRootPane());
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this.getRootPane(), id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this.getRootPane());
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this.getRootPane());
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this.getRootPane(), skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this.getRootPane(), skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this.getRootPane());
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this.getRootPane(), listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this.getRootPane(), listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this.getRootPane());
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this.getRootPane(), painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this.getRootPane());
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this.getRootPane());
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this.getRootPane());
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this.getRootPane(), enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this.getRootPane());
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this.getRootPane(), margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this.getRootPane(), top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this.getRootPane(), margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this.getRootPane());
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this.getRootPane(), padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this.getRootPane(), top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this.getRootPane(), padding);
    }

    public WRootPaneUI getUI() {
        return (WRootPaneUI)this.getRootPane().getUI();
    }

    public void setUI(WRootPaneUI ui) {
        this.getRootPane().setUI(ui);
    }

    @Override
    public WindowAdapter onClosing(WindowEventRunnable runnable) {
        return WindowEventMethodsImpl.onClosing(this, runnable);
    }

    @Override
    public WindowCloseAdapter onClose(ComponentEventRunnable runnable) {
        return WindowEventMethodsImpl.onClose(this, runnable);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this.getRootPane());
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this.getRootPane(), key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this.getRootPane(), data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this.getRootPane(), key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this.getRootPane());
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this.getRootPane());
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this.getRootPane(), updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this.getRootPane());
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this.getRootPane());
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this.getRootPane());
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this.getRootPane(), configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this.getRootPane(), processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this.getRootPane());
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this.getRootPane());
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this.getRootPane());
    }

    @Override
    public boolean isWindowOpaque() {
        return WindowMethodsImpl.isWindowOpaque(this);
    }

    @Override
    public T setWindowOpaque(boolean opaque) {
        return (T)((WebDialog)WindowMethodsImpl.setWindowOpaque(this, opaque));
    }

    @Override
    public float getWindowOpacity() {
        return WindowMethodsImpl.getWindowOpacity(this);
    }

    @Override
    public T setWindowOpacity(float opacity) {
        return (T)((WebDialog)WindowMethodsImpl.setWindowOpacity(this, opacity));
    }

    @Override
    public T center() {
        return (T)((WebDialog)WindowMethodsImpl.center(this));
    }

    @Override
    public T center(Component relativeTo) {
        return (T)((WebDialog)WindowMethodsImpl.center(this, relativeTo));
    }

    @Override
    public T center(int width, int height) {
        return (T)((WebDialog)WindowMethodsImpl.center(this, width, height));
    }

    @Override
    public T center(Component relativeTo, int width, int height) {
        return (T)((WebDialog)WindowMethodsImpl.center(this, relativeTo, width, height));
    }

    @Override
    public T packToWidth(int width) {
        return (T)((WebDialog)WindowMethodsImpl.packToWidth(this, width));
    }

    @Override
    public T packToHeight(int height) {
        return (T)((WebDialog)WindowMethodsImpl.packToHeight(this, height));
    }

    public class WebDialogRootPane
    extends WebRootPane {
        public WebDialogRootPane() {
            super(StyleManager.getDescriptor(WebDialogRootPane.class).getDefaultStyleId());
        }

        @Override
        @NotNull
        public StyleId getDefaultStyleId() {
            return WebDialog.this.getDefaultStyleId();
        }
    }
}

