/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.viewport;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.scroll.layout.ScrollBarSettings;
import com.alee.laf.scroll.layout.ScrollPaneLayout;
import com.alee.laf.viewport.WViewportUI;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class WebViewport
extends JViewport
implements Styleable {
    public WebViewport() {
        this(StyleId.auto);
    }

    public WebViewport(StyleId id) {
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.viewport;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this);
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this, id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this);
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this);
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this);
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this);
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this);
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this, enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this);
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this, top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this);
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this, top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public WViewportUI getUI() {
        return (WViewportUI)this.ui;
    }

    public void setUI(WViewportUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }

    @Override
    public void scrollRectToVisible(Rectangle newRect) {
        LayoutManager layout;
        JScrollPane scrollPane;
        Container scroll = this.getParent();
        if (scroll instanceof JScrollPane && this == (scrollPane = (JScrollPane)scroll).getViewport() && (layout = scrollPane.getLayout()) instanceof ScrollPaneLayout) {
            JScrollBar hsb;
            ScrollBarSettings hpos;
            JScrollBar vsb;
            Rectangle curRect = this.getVisibleRect();
            ScrollBarSettings vpos = ((ScrollPaneLayout)layout).getVerticalScrollBarPosition();
            if (vpos.isHovering() && vpos.isExtending() && (vsb = scrollPane.getVerticalScrollBar()) != null && vsb.isShowing()) {
                newRect.x += this.calculateAdjustment(curRect.x, curRect.width, newRect.x, newRect.width, vsb.getWidth());
            }
            if ((hpos = ((ScrollPaneLayout)layout).getHorizontalScrollBarPosition()).isHovering() && hpos.isExtending() && (hsb = scrollPane.getHorizontalScrollBar()) != null && hsb.isShowing()) {
                newRect.y += this.calculateAdjustment(curRect.y, curRect.height, newRect.y, newRect.height, hsb.getHeight());
            }
        }
        super.scrollRectToVisible(newRect);
    }

    private int calculateAdjustment(int curPos, int curLen, int newPos, int newLen, int barLen) {
        int len = Math.min(curLen, newLen);
        return curPos + curLen < newPos + len + barLen ? barLen : 0;
    }
}

