/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree.walker;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Consumer;
import com.alee.api.jdk.Predicate;
import com.alee.laf.tree.walker.TreeWalker;
import com.alee.laf.tree.walker.TreeWalkerException;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public abstract class AbstractTreeWalker<N extends TreeNode, M extends TreeModel>
implements TreeWalker<N> {
    @NotNull
    protected final JTree tree;
    @Nullable
    protected N parent;
    protected int index;

    public AbstractTreeWalker(@NotNull JTree tree) {
        this.tree = tree;
    }

    @Override
    public void forEach(@NotNull Consumer<N> action) {
        N node;
        while ((node = this.nextNode()) != null) {
            action.accept(node);
        }
        this.reset();
    }

    @Override
    public boolean anyMatch(@NotNull Predicate<N> predicate) {
        N node;
        boolean anyMatch = false;
        while ((node = this.nextNode()) != null) {
            if (!predicate.test(node)) continue;
            anyMatch = true;
            break;
        }
        return anyMatch;
    }

    @Override
    public boolean allMatch(@NotNull Predicate<N> predicate) {
        N node;
        boolean allMatch = true;
        while ((node = this.nextNode()) != null) {
            if (predicate.test(node)) continue;
            allMatch = false;
            break;
        }
        return allMatch;
    }

    @Override
    public boolean noneMatch(@NotNull Predicate<N> predicate) {
        N node;
        boolean noneMatch = true;
        while ((node = this.nextNode()) != null) {
            if (!predicate.test(node)) continue;
            noneMatch = false;
            break;
        }
        return noneMatch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected N nextNode() {
        N node;
        TreeModel model = this.tree.getModel();
        if (this.parent == null) {
            node = this.getRootNode(model);
            this.parent = node;
            this.index = 0;
            return node;
        } else if (this.getChildCount(model, this.parent) > this.index) {
            node = this.getChild(model, this.parent, this.index);
            this.parent = node;
            this.index = 0;
            return node;
        } else {
            N child = this.parent;
            this.parent = this.parent.getParent();
            if (this.parent != null) {
                int childIndex = this.getIndexOfChild(model, this.parent, child);
                if (childIndex == -1) throw new TreeWalkerException("Provided child is not contained within its parent");
                this.index = childIndex + 1;
                node = this.nextNode();
                return node;
            } else {
                node = null;
            }
        }
        return node;
    }

    protected void reset() {
        this.parent = null;
        this.index = -1;
    }

    @NotNull
    protected abstract N getRootNode(@NotNull M var1);

    protected abstract int getChildCount(@NotNull M var1, @NotNull N var2);

    @NotNull
    protected abstract N getChild(@NotNull M var1, @NotNull N var2, int var3);

    protected abstract int getIndexOfChild(@NotNull M var1, @NotNull N var2, @NotNull N var3);
}

