/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree.behavior;

import com.alee.extended.behavior.Behavior;
import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

public class TreeSingleChildExpandBehavior
implements TreeExpansionListener,
Behavior {
    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        JTree tree = (JTree)event.getSource();
        TreePath expandedPath = event.getPath();
        Object expandedObject = expandedPath.getLastPathComponent();
        if (tree.getModel().getChildCount(expandedObject) == 1) {
            Object[] parentPath = expandedPath.getPath();
            Object[] path = Arrays.copyOf(parentPath, parentPath.length + 1);
            path[parentPath.length] = tree.getModel().getChild(expandedObject, 0);
            tree.expandPath(new TreePath(path));
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public static TreeSingleChildExpandBehavior install(JTree tree) {
        TreeSingleChildExpandBehavior.uninstall(tree);
        TreeSingleChildExpandBehavior behavior = new TreeSingleChildExpandBehavior();
        tree.addTreeExpansionListener(behavior);
        return behavior;
    }

    public static void uninstall(JTree tree) {
        for (TreeExpansionListener listener : tree.getTreeExpansionListeners()) {
            if (!(listener instanceof TreeSingleChildExpandBehavior)) continue;
            tree.removeTreeExpansionListener(listener);
        }
    }

    public static boolean isInstalled(JTree tree) {
        for (TreeExpansionListener listener : tree.getTreeExpansionListeners()) {
            if (!(listener instanceof TreeSingleChildExpandBehavior)) continue;
            return true;
        }
        return false;
    }
}

