/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.tree.TreeUtils;
import com.alee.utils.collection.EmptyEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebTreeNode<N extends WebTreeNode<N, T>, T>
implements MutableTreeNode,
Cloneable,
Serializable {
    @Nullable
    protected N parent = null;
    @Nullable
    protected List<N> children;
    protected boolean allowsChildren;
    @Nullable
    protected transient T userObject;

    public WebTreeNode() {
        this(null);
    }

    public WebTreeNode(@Nullable T userObject) {
        this(userObject, true);
    }

    public WebTreeNode(@Nullable T userObject, boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
        this.userObject = userObject;
    }

    @Override
    public void insert(@NotNull MutableTreeNode child, int index) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("Node does not allow children");
        }
        if (this.isNodeAncestor((WebTreeNode)child)) {
            throw new IllegalArgumentException("New child is an ancestor");
        }
        WebTreeNode oldParent = (WebTreeNode)child.getParent();
        if (oldParent != null) {
            oldParent.remove(child);
        }
        child.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<N>();
        }
        this.children.add(index, (WebTreeNode)child);
    }

    @Override
    public void remove(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("Node has no children");
        }
        TreeNode child = this.getChildAt(index);
        this.children.remove(index);
        ((WebTreeNode)child).setParent(null);
    }

    @Override
    public void setParent(@Nullable MutableTreeNode parent) {
        this.parent = (WebTreeNode)parent;
    }

    @Nullable
    public N getParent() {
        return this.parent;
    }

    @NotNull
    public N getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("Node has no children");
        }
        return (N)((WebTreeNode)this.children.get(index));
    }

    @Override
    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public int getIndex(@NotNull TreeNode child) {
        return this.children != null ? this.children.indexOf(child) : -1;
    }

    @NotNull
    public Enumeration<N> children() {
        return this.children != null ? Collections.enumeration(this.children) : EmptyEnumeration.instance();
    }

    public void setAllowsChildren(boolean allows) {
        if (allows != this.allowsChildren) {
            this.allowsChildren = allows;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public void setUserObject(@Nullable Object userObject) {
        this.userObject = userObject;
    }

    @Nullable
    public T getUserObject() {
        return this.userObject;
    }

    @Override
    public void removeFromParent() {
        TreeNode parent = this.getParent();
        if (parent != null) {
            ((WebTreeNode)parent).remove(this);
        }
    }

    @Override
    public void remove(@NotNull MutableTreeNode child) {
        int index = this.getIndex(child);
        if (index == -1) {
            throw new IllegalArgumentException("Node is not a child");
        }
        this.remove(index);
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void add(@NotNull MutableTreeNode child) {
        this.insert(child, this.getChildCount() - (child.getParent() == this ? 1 : 0));
    }

    public boolean isNodeAncestor(@Nullable N anotherNode) {
        boolean isAncestor = false;
        if (anotherNode != null) {
            TreeNode ancestor = this;
            do {
                if (ancestor != anotherNode) continue;
                isAncestor = true;
                break;
            } while ((ancestor = ancestor.getParent()) != null);
        }
        return isAncestor;
    }

    public boolean isNodeDescendant(@Nullable N anotherNode) {
        return anotherNode != null && anotherNode.isNodeAncestor((WebTreeNode)this);
    }

    @Nullable
    public N getSharedAncestor(@Nullable N anotherNode) {
        Object result2 = null;
        boolean finished = false;
        if (anotherNode == this) {
            result2 = this;
        } else if (anotherNode != null) {
            TreeNode node2;
            Object node1;
            int diff;
            int level1 = this.getLevel();
            int level2 = ((WebTreeNode)anotherNode).getLevel();
            if (level2 > level1) {
                diff = level2 - level1;
                node1 = anotherNode;
                node2 = this;
            } else {
                diff = level1 - level2;
                node1 = this;
                node2 = anotherNode;
            }
            while (diff > 0) {
                node1 = ((WebTreeNode)node1).getParent();
                --diff;
            }
            do {
                if (node1 == node2) {
                    result2 = node1;
                    finished = true;
                    break;
                }
                node1 = ((WebTreeNode)node1).getParent();
                node2 = node2.getParent();
            } while (node1 != null);
            if (!(finished || node1 == null && node2 == null)) {
                throw new Error("Nodes shouldn't be null");
            }
        }
        return (N)result2;
    }

    public boolean isNodeRelated(@Nullable N anotherNode) {
        return anotherNode != null && this.getRoot() == ((WebTreeNode)anotherNode).getRoot();
    }

    public int getDepth() {
        WebTreeNode last = null;
        Enumeration<N> breadthFirst = this.breadthFirstEnumeration();
        while (breadthFirst.hasMoreElements()) {
            last = (WebTreeNode)breadthFirst.nextElement();
        }
        if (last == null) {
            throw new Error("Nodes shouldn't be null");
        }
        return last.getLevel() - this.getLevel();
    }

    public int getLevel() {
        int levels = 0;
        TreeNode ancestor = this;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    @NotNull
    public TreePath getTreePath() {
        TreePath treePath = TreeUtils.getTreePath(this);
        if (treePath == null) {
            throw new Error("TreePath is null");
        }
        return treePath;
    }

    @NotNull
    public TreeNode[] getPath() {
        TreeNode[] path = TreeUtils.getPath(this);
        if (path == null) {
            throw new Error("Path is null");
        }
        return path;
    }

    @NotNull
    public T[] getUserObjectPath() {
        T userObject = this.getUserObject();
        if (userObject == null) {
            throw new IllegalStateException("UserObject shouldn't be null");
        }
        Class<?> type = userObject.getClass();
        TreeNode[] realPath = this.getPath();
        Object[] path = (Object[])Array.newInstance(type, realPath.length);
        for (int counter = 0; counter < realPath.length; ++counter) {
            path[counter] = ((WebTreeNode)realPath[counter]).getUserObject();
        }
        return path;
    }

    @NotNull
    public N getRoot() {
        TreeNode parent = this.getParent();
        return (N)(parent != null ? ((WebTreeNode)parent).getRoot() : this);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Nullable
    public N getNextNode() {
        TreeNode next;
        block6: {
            if (this.getChildCount() == 0) {
                N nextSibling = this.getNextSibling();
                if (nextSibling == null) {
                    TreeNode aNode = this.getParent();
                    while (true) {
                        if (aNode == null) {
                            next = null;
                            break block6;
                        }
                        nextSibling = ((WebTreeNode)aNode).getNextSibling();
                        if (nextSibling != null) {
                            next = nextSibling;
                            break block6;
                        }
                        aNode = ((WebTreeNode)aNode).getParent();
                    }
                }
                next = nextSibling;
            } else {
                next = this.getChildAt(0);
            }
        }
        return (N)next;
    }

    @Nullable
    public N getPreviousNode() {
        N previousSibling;
        TreeNode myParent = this.getParent();
        Object previous = myParent != null ? ((previousSibling = this.getPreviousSibling()) != null ? (((WebTreeNode)previousSibling).getChildCount() == 0 ? previousSibling : ((WebTreeNode)previousSibling).getLastLeaf()) : myParent) : null;
        return (N)previous;
    }

    @NotNull
    public Enumeration<N> preorderEnumeration() {
        return new PreorderEnumeration(this, this);
    }

    @NotNull
    public Enumeration<N> postorderEnumeration() {
        return new PostorderEnumeration(this, this);
    }

    @NotNull
    public Enumeration<N> breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this, this);
    }

    @NotNull
    public Enumeration<N> depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    @NotNull
    public Enumeration pathFromAncestorEnumeration(@NotNull N ancestor) {
        return new PathBetweenNodesEnumeration(this, ancestor, this);
    }

    public boolean isNodeChild(@Nullable N anotherNode) {
        return anotherNode != null && this.getChildCount() != 0 && ((WebTreeNode)anotherNode).getParent() == this;
    }

    @NotNull
    public N getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return (N)this.getChildAt(0);
    }

    @NotNull
    public N getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return (N)this.getChildAt(this.getChildCount() - 1);
    }

    @Nullable
    public N getChildAfter(@NotNull N child) {
        int index = this.getIndex((TreeNode)child);
        if (index == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        return (N)(index < this.getChildCount() - 1 ? this.getChildAt(index + 1) : null);
    }

    @Nullable
    public N getChildBefore(@NotNull N child) {
        int index = this.getIndex((TreeNode)child);
        if (index == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        return (N)(index > 0 ? this.getChildAt(index - 1) : null);
    }

    public boolean isNodeSibling(@Nullable N anotherNode) {
        boolean sibling;
        if (anotherNode == null) {
            sibling = false;
        } else if (anotherNode == this) {
            sibling = true;
        } else {
            TreeNode myParent = this.getParent();
            boolean bl = sibling = myParent != null && myParent == ((WebTreeNode)anotherNode).getParent();
            if (sibling && !((WebTreeNode)this.getParent()).isNodeChild(anotherNode)) {
                throw new Error("sibling has different parent");
            }
        }
        return sibling;
    }

    public int getSiblingCount() {
        TreeNode myParent = this.getParent();
        return myParent != null ? ((WebTreeNode)myParent).getChildCount() : 1;
    }

    @Nullable
    public N getNextSibling() {
        TreeNode myParent = this.getParent();
        WebTreeNode nextSibling = myParent != null ? ((WebTreeNode)myParent).getChildAfter(this) : null;
        if (nextSibling != null && !this.isNodeSibling(nextSibling)) {
            throw new Error("child of parent is not a sibling");
        }
        return (N)nextSibling;
    }

    @Nullable
    public N getPreviousSibling() {
        TreeNode myParent = this.getParent();
        WebTreeNode previousSibling = myParent != null ? ((WebTreeNode)myParent).getChildBefore(this) : null;
        if (previousSibling != null && !this.isNodeSibling(previousSibling)) {
            throw new Error("child of parent is not a sibling");
        }
        return (N)previousSibling;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @NotNull
    public N getFirstLeaf() {
        WebTreeNode<N, T> node = this;
        while (!node.isLeaf()) {
            node = node.getFirstChild();
        }
        return (N)node;
    }

    @NotNull
    public N getLastLeaf() {
        WebTreeNode<N, T> node = this;
        while (!node.isLeaf()) {
            node = node.getLastChild();
        }
        return (N)node;
    }

    @Nullable
    public N getNextLeaf() {
        N nextSibling;
        TreeNode myParent = this.getParent();
        N nextLeaf = myParent != null ? ((nextSibling = this.getNextSibling()) != null ? (N)((WebTreeNode)nextSibling).getFirstLeaf() : (N)((WebTreeNode)myParent).getNextLeaf()) : null;
        return nextLeaf;
    }

    @Nullable
    public N getPreviousLeaf() {
        N previousSibling;
        TreeNode myParent = this.getParent();
        N previousLeaf = myParent != null ? ((previousSibling = this.getPreviousSibling()) != null ? (N)((WebTreeNode)previousSibling).getLastLeaf() : (N)((WebTreeNode)myParent).getPreviousLeaf()) : null;
        return previousLeaf;
    }

    public int getLeafCount() {
        int count = 0;
        Enumeration<N> breadthFirst = this.breadthFirstEnumeration();
        while (breadthFirst.hasMoreElements()) {
            WebTreeNode node = (WebTreeNode)breadthFirst.nextElement();
            if (!node.isLeaf()) continue;
            ++count;
        }
        if (count < 1) {
            throw new Error("tree has zero leaves");
        }
        return count;
    }

    @Nullable
    public String toString() {
        return this.userObject != null ? this.userObject.toString() : null;
    }

    @NotNull
    public WebTreeNode<N, T> clone() {
        WebTreeNode newNode;
        try {
            newNode = (WebTreeNode)super.clone();
            newNode.children = null;
            newNode.parent = null;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        return newNode;
    }

    private void writeObject(@NotNull ObjectOutputStream outputStream) throws IOException {
        outputStream.defaultWriteObject();
        Serializable[] tValues = this.userObject != null && this.userObject instanceof Serializable ? new Serializable[]{"userObject", (Serializable)this.userObject} : new Serializable[]{};
        outputStream.writeObject(tValues);
    }

    private void readObject(@NotNull ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        Serializable[] tValues = (Serializable[])inputStream.readObject();
        if (tValues.length > 0 && tValues[0].equals("userObject")) {
            this.userObject = tValues[1];
        }
    }

    private static final class PathBetweenNodesEnumeration<E extends WebTreeNode<E, V>, V>
    implements Enumeration<E> {
        @NotNull
        private final Stack<E> stack = new Stack();
        final /* synthetic */ WebTreeNode this$0;

        public PathBetweenNodesEnumeration(@NotNull E ancestor, E descendant) {
            this.this$0 = var1_1;
            this.stack.push(descendant);
            Object current = descendant;
            while (current != ancestor) {
                if ((current = ((WebTreeNode)current).getParent()) == null) {
                    String msg = "Node '%s' is not an ancestor of '%s'";
                    throw new IllegalArgumentException(String.format("Node '%s' is not an ancestor of '%s'", ancestor, descendant));
                }
                this.stack.push(current);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.stack.size() > 0;
        }

        @Override
        @NotNull
        public E nextElement() {
            try {
                return (E)((WebTreeNode)this.stack.pop());
            }
            catch (EmptyStackException e) {
                throw new NoSuchElementException("No more elements");
            }
        }
    }

    private static final class BreadthFirstEnumeration<E extends WebTreeNode<E, V>, V>
    implements Enumeration<E> {
        @NotNull
        private final Queue<Enumeration<E>> queue = new Queue();
        final /* synthetic */ WebTreeNode this$0;

        public BreadthFirstEnumeration(E rootNode) {
            this.this$0 = var1_1;
            this.queue.enqueue(Collections.enumeration(Collections.singletonList(rootNode)));
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && this.queue.firstObject().hasMoreElements();
        }

        @Override
        @NotNull
        public E nextElement() {
            Enumeration<E> enumeration = this.queue.firstObject();
            WebTreeNode node = (WebTreeNode)enumeration.nextElement();
            Enumeration children = node.children();
            if (!enumeration.hasMoreElements()) {
                this.queue.dequeue();
            }
            if (children.hasMoreElements()) {
                this.queue.enqueue(children);
            }
            return (E)node;
        }

        private final class Queue<Q> {
            @Nullable
            private QNode<Q> head;
            @Nullable
            private QNode<Q> tail;

            private Queue() {
            }

            public void enqueue(@NotNull Q object) {
                if (this.head == null || this.tail == null) {
                    this.tail = new QNode<Q>(object, null);
                    this.head = this.tail;
                } else {
                    this.tail.next = new QNode<Q>(object, null);
                    this.tail = this.tail.next;
                }
            }

            @NotNull
            public Q dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object retval = this.head.object;
                QNode<Q> oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
                return (Q)retval;
            }

            @NotNull
            public Q firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return (Q)this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            private final class QNode<O> {
                @NotNull
                public final O object;
                @Nullable
                public QNode<O> next;

                public QNode(@Nullable O object, QNode<O> next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    private static final class PostorderEnumeration<E extends WebTreeNode<E, V>, V>
    implements Enumeration<E> {
        @Nullable
        protected E root;
        @NotNull
        protected Enumeration<E> children;
        @NotNull
        protected Enumeration<E> subtree;
        final /* synthetic */ WebTreeNode this$0;

        public PostorderEnumeration(E rootNode) {
            this.this$0 = var1_1;
            this.root = rootNode;
            this.children = ((WebTreeNode)rootNode).children();
            this.subtree = EmptyEnumeration.instance();
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        @Override
        @NotNull
        public E nextElement() {
            WebTreeNode retval;
            if (this.subtree.hasMoreElements()) {
                retval = (WebTreeNode)this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration(this.this$0, (WebTreeNode)this.children.nextElement());
                retval = (WebTreeNode)this.subtree.nextElement();
            } else if (this.root != null) {
                retval = this.root;
                this.root = null;
            } else {
                throw new NoSuchElementException("No more elements");
            }
            return (E)retval;
        }
    }

    private static final class PreorderEnumeration<E extends WebTreeNode<E, V>, V>
    implements Enumeration<E> {
        @NotNull
        private final Stack<Enumeration<E>> stack = new Stack();
        final /* synthetic */ WebTreeNode this$0;

        public PreorderEnumeration(E rootNode) {
            this.this$0 = var1_1;
            this.stack.push(Collections.enumeration(Collections.singletonList(rootNode)));
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && this.stack.peek().hasMoreElements();
        }

        @Override
        @NotNull
        public E nextElement() {
            Enumeration<E> enumeration = this.stack.peek();
            WebTreeNode node = (WebTreeNode)enumeration.nextElement();
            Enumeration children = node.children();
            if (!enumeration.hasMoreElements()) {
                this.stack.pop();
            }
            if (children.hasMoreElements()) {
                this.stack.push(children);
            }
            return (E)node;
        }
    }
}

