/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.NodeState;
import com.alee.laf.tree.TreeState;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Map;

public class TreeStateConverter
extends ReflectionConverter {
    public TreeStateConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(TreeState.class);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TreeState treeState = (TreeState)source;
        for (Map.Entry<String, NodeState> entry : treeState.states().entrySet()) {
            String nodeId = entry.getKey();
            NodeState nodeState = entry.getValue();
            writer.startNode("node");
            writer.addAttribute("id", nodeId);
            writer.addAttribute("expanded", "" + nodeState.isExpanded());
            writer.addAttribute("selected", "" + nodeState.isSelected());
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeState state = new TreeState();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeId = reader.getAttribute("id");
            String expandedAttribue = reader.getAttribute("expanded");
            boolean expanded = Boolean.parseBoolean(expandedAttribue != null ? expandedAttribue : "false");
            String selectedAttribue = reader.getAttribute("selected");
            boolean selected = Boolean.parseBoolean(selectedAttribue != null ? selectedAttribue : "false");
            state.addState(nodeId, new NodeState(expanded, selected));
            reader.moveUp();
        }
        return state;
    }
}

