/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.text.WTextPaneUI;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.ReflectUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.plaf.ComponentUI;

public class WebTextPaneUI
extends WTextPaneUI {
    protected String inputPrompt;
    protected transient JTextPane textPane = null;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebTextPaneUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.textPane = (JTextPane)c;
        super.installUI(c);
        StyleManager.installSkin(this.textPane);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.textPane);
        super.uninstallUI(c);
        this.textPane = null;
    }

    @Override
    @Nullable
    public String getInputPrompt() {
        return this.inputPrompt;
    }

    @Override
    public void setInputPrompt(@Nullable String text) {
        if (Objects.notEquals((Object)text, (Object)this.inputPrompt)) {
            this.inputPrompt = text;
            this.textPane.repaint();
        }
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    protected void paintSafely(@NotNull Graphics g) {
        ReflectUtils.setFieldValueSafely((Object)this, "painted", (Object)true);
        PainterSupport.paint(g, this.getComponent(), this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c));
    }
}

