/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.text.TextComponentState;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.text.JTextComponent;

public class TextComponentSettingsProcessor<C extends JTextComponent, V extends TextComponentState>
extends SettingsProcessor<C, V, Configuration<V>> {
    protected transient FocusListener focusListener;

    public TextComponentSettingsProcessor(C textComponent, Configuration<V> configuration) {
        super(textComponent, configuration);
    }

    @Override
    protected void register(@NotNull C textComponent) {
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TextComponentSettingsProcessor.this.save();
            }
        };
        ((Component)textComponent).addFocusListener(this.focusListener);
    }

    @Override
    protected void unregister(@NotNull C textComponent) {
        ((Component)textComponent).removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    @Override
    @Nullable
    protected V createDefaultValue() {
        return (V)new TextComponentState();
    }

    @Override
    protected void loadSettings(@NotNull C textComponent) {
        ((TextComponentState)this.loadSettings()).apply((JTextComponent)textComponent);
    }

    @Override
    protected void saveSettings(@NotNull C textComponent) {
        this.saveSettings((C)this.stateFor(textComponent));
    }

    protected V stateFor(C textComponent) {
        return (V)new TextComponentState((JTextComponent)textComponent);
    }
}

