/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.text.AbstractTextEditorPainter;
import com.alee.laf.text.IAbstractTextFieldPainter;
import com.alee.laf.text.TextFieldLayout;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.JTextComponent;

public abstract class AbstractTextFieldPainter<C extends JTextComponent, U extends BasicTextUI, D extends IDecoration<C, D>>
extends AbstractTextEditorPainter<C, U, D>
implements IAbstractTextFieldPainter<C, U> {
    protected transient ComponentAdapter componentResizeListener;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installCustomSettings();
        this.installLeadingTrailingResizeListener();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallLeadingTrailingResizeListener();
        this.uninstallCustomLayout();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"enabled")) {
            if (this.getLeadingComponent() != null) {
                SwingUtils.setEnabledRecursively(this.getLeadingComponent(), ((JTextComponent)this.component).isEnabled());
            }
            if (this.getTrailingComponent() != null) {
                SwingUtils.setEnabledRecursively(this.getTrailingComponent(), ((JTextComponent)this.component).isEnabled());
            }
        }
        if (Objects.equals((Object)property, "leadingComponent", "trailingComponent")) {
            this.uninstallResizeListener((Component)oldValue);
            this.installResizeListener((Component)newValue);
            this.updateBorder();
        }
    }

    protected void installCustomSettings() {
        SwingUtils.setHandlesEnableStateMark(this.component);
        ((JTextComponent)this.component).setLayout(new TextFieldLayout(this));
    }

    protected void uninstallCustomLayout() {
        ((JTextComponent)this.component).setLayout(null);
        SwingUtils.removeHandlesEnableStateMark(this.component);
    }

    protected void installLeadingTrailingResizeListener() {
        this.componentResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractTextFieldPainter.this.updateBorder();
            }
        };
        this.installResizeListener(this.getLeadingComponent());
        this.installResizeListener(this.getTrailingComponent());
    }

    protected void uninstallLeadingTrailingResizeListener() {
        this.uninstallResizeListener(this.getTrailingComponent());
        this.uninstallResizeListener(this.getLeadingComponent());
        this.componentResizeListener = null;
    }

    protected void installResizeListener(Component component2) {
        if (component2 != null) {
            component2.addComponentListener(this.componentResizeListener);
        }
    }

    protected void uninstallResizeListener(Component component2) {
        if (component2 != null) {
            component2.removeComponentListener(this.componentResizeListener);
        }
    }

    @Override
    @Nullable
    protected Insets getBorder() {
        Insets result2;
        Insets border = super.getBorder();
        Component lc = this.getLeadingComponent();
        Component tc = this.getTrailingComponent();
        if (lc != null || tc != null) {
            int right;
            int left = lc != null ? lc.getPreferredSize().width : 0;
            int n = right = tc != null ? tc.getPreferredSize().width : 0;
            result2 = border != null ? new Insets(border.top, border.left + left, border.bottom, border.right + right) : new Insets(0, left, 0, right);
        } else {
            result2 = border;
        }
        return result2;
    }
}

