/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.DocumentChangeBehavior;
import com.alee.laf.text.IAbstractTextEditorPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.xml.FontConverter;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import java.util.Map;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public abstract class AbstractTextEditorPainter<C extends JTextComponent, U extends TextUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements IAbstractTextEditorPainter<C, U>,
SwingConstants {
    protected int inputPromptHorizontalPosition = 0;
    protected int inputPromptVerticalPosition = 0;
    @XStreamConverter(value=FontConverter.class)
    protected Font inputPromptFont = null;
    protected Color inputPromptForeground = new Color(160, 160, 160);
    protected boolean inputPromptOnlyWhenEditable = true;
    protected boolean hideInputPromptOnFocus = true;
    protected transient DocumentChangeBehavior<C> documentChangeBehavior;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installDocumentChangeListener();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallDocumentChangeListener();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"editable")) {
            this.updateDecorationState();
        }
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (((JTextComponent)this.component).isEditable()) {
            states.add("editable");
        }
        if (SwingUtils.isEmpty((JTextComponent)this.component)) {
            states.add("empty");
        }
        return states;
    }

    protected void installDocumentChangeListener() {
        this.documentChangeBehavior = new DocumentChangeBehavior<C>((JTextComponent)this.component){

            @Override
            public void documentChanged(@NotNull C component2, @Nullable DocumentEvent event) {
                AbstractTextEditorPainter.this.updateDecorationState();
            }
        }.install();
    }

    protected void uninstallDocumentChangeListener() {
        this.documentChangeBehavior.uninstall();
        this.documentChangeBehavior = null;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        DefaultCaret dropCaret;
        Highlighter highlighter = ((JTextComponent)c).getHighlighter();
        if (highlighter != null) {
            highlighter.paint(g2d);
        }
        Map hints = SwingUtils.setupTextAntialias(g2d);
        this.paintInputPrompt(g2d, c, ui);
        Rectangle alloc = this.getEditorRect(c, ui);
        if (alloc != null) {
            ((TextUI)ui).getRootView((JTextComponent)c).paint(g2d, alloc);
        }
        SwingUtils.restoreTextAntialias(g2d, hints);
        Caret caret = ((JTextComponent)c).getCaret();
        if (caret != null) {
            caret.paint(g2d);
        }
        if ((dropCaret = (DefaultCaret)ReflectUtils.getFieldValueSafely(ui, "dropCaret")) != null) {
            dropCaret.paint(g2d);
        }
    }

    protected void paintInputPrompt(@NotNull Graphics2D g2d, C c, U ui) {
        Rectangle b;
        if (this.isInputPromptVisible() && (b = this.getEditorRect(c, ui)) != null) {
            Shape oc = GraphicsUtils.intersectClip(g2d, b);
            g2d.setFont(this.inputPromptFont != null ? this.inputPromptFont : ((JTextComponent)this.component).getFont());
            g2d.setPaint(this.inputPromptForeground != null ? this.inputPromptForeground : ((JTextComponent)this.component).getForeground());
            String text = this.getInputPrompt();
            FontMetrics fm = g2d.getFontMetrics();
            int x = this.inputPromptHorizontalPosition == 0 ? b.x + b.width / 2 - fm.stringWidth(text) / 2 : (this.ltr && this.inputPromptHorizontalPosition == 10 || !this.ltr && this.inputPromptHorizontalPosition == 11 || this.inputPromptHorizontalPosition == 2 ? b.x : b.x + b.width - fm.stringWidth(text));
            int y = this.inputPromptVerticalPosition == 0 ? b.y + b.height / 2 + LafUtils.getTextCenterShiftY(fm) : ((TextUI)this.ui).getBaseline(this.component, ((JTextComponent)this.component).getWidth(), ((JTextComponent)this.component).getHeight());
            g2d.drawString(text, x, y);
            GraphicsUtils.restoreClip(g2d, oc);
        }
    }

    @Nullable
    protected Rectangle getEditorRect(C c, U ui) {
        Rectangle editorBounds;
        Dimension size = ((Component)c).getSize();
        if (size.width > 0 && size.height > 0) {
            Insets insets = ((JTextComponent)this.component).getInsets();
            Rectangle innerBounds = new Rectangle(0, 0, size.width, size.height);
            editorBounds = SwingUtils.shrink(innerBounds, insets);
            if (SystemUtils.isJava9orAbove()) {
                Integer caretMargin = (Integer)ReflectUtils.getFieldValueSafely(ui, "caretMargin");
                if (caretMargin == null) {
                    caretMargin = 1;
                }
                editorBounds.width -= caretMargin.intValue();
            }
        } else {
            editorBounds = null;
        }
        return editorBounds;
    }

    @Override
    public boolean isInputPromptVisible() {
        String inputPrompt = this.getInputPrompt();
        return TextUtils.notEmpty(inputPrompt) && SwingUtils.isEmpty((JTextComponent)this.component) && (!this.inputPromptOnlyWhenEditable || ((JTextComponent)this.component).isEditable() && ((JTextComponent)this.component).isEnabled()) && (!this.hideInputPromptOnFocus || !this.isFocused());
    }
}

