/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table.renderers;

import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.laf.table.TableCellParameters;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class WebTableBooleanCellRenderer<C extends JTable, P extends TableCellParameters<Boolean, C>>
extends WebCheckBox
implements TableCellRenderer,
Stateful {
    protected final List<String> states;

    public WebTableBooleanCellRenderer() {
        this.setName("Table.cellRenderer");
        this.states = new ArrayList<String>(3);
    }

    @Override
    @Nullable
    public List<String> getStates() {
        return this.states;
    }

    protected void updateStates(P parameters) {
        this.states.clear();
        this.states.add(((TableCellParameters)parameters).isSelected() ? "selected" : "unselected");
        if (((TableCellParameters)parameters).isFocused()) {
            this.states.add("focused");
        }
    }

    protected void updateStyleId(P parameters) {
        this.setStyleId(StyleId.tableCellRendererBoolean.at((JComponent)((TableCellParameters)parameters).table()));
    }

    protected void updateView(P parameters) {
        this.setEnabled(this.enabledForValue(parameters));
        this.setComponentOrientation(this.orientationForValue(parameters));
        this.setFont(this.fontForValue(parameters));
        this.setForeground(this.foregroundForValue(parameters));
        this.setHorizontalAlignment(this.horizontalAlignmentForValue(parameters));
        this.setSelected(this.selectedForValue(parameters));
        this.setText(this.textForValue(parameters));
    }

    protected boolean enabledForValue(P parameters) {
        return ((Component)((TableCellParameters)parameters).table()).isEnabled();
    }

    protected ComponentOrientation orientationForValue(P parameters) {
        return ((Component)((TableCellParameters)parameters).table()).getComponentOrientation();
    }

    protected Font fontForValue(P parameters) {
        return ((Component)((TableCellParameters)parameters).table()).getFont();
    }

    protected Color foregroundForValue(P parameters) {
        return ((TableCellParameters)parameters).isSelected() ? ((JTable)((TableCellParameters)parameters).table()).getSelectionForeground() : ((Component)((TableCellParameters)parameters).table()).getForeground();
    }

    protected int horizontalAlignmentForValue(P parameters) {
        return 0;
    }

    protected boolean selectedForValue(P parameters) {
        return ((TableCellParameters)parameters).value() != null && (Boolean)((TableCellParameters)parameters).value() != false;
    }

    protected String textForValue(P parameters) {
        return null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        P parameters = this.getRenderingParameters(table2, (Boolean)value, isSelected, hasFocus, row, column);
        this.updateStates(parameters);
        this.updateStyleId(parameters);
        this.updateView(parameters);
        DecorationUtils.fireStatesChanged(this);
        return this;
    }

    protected P getRenderingParameters(C table2, Boolean value, boolean isSelected, boolean hasFocus, int row, int column) {
        return (P)new TableCellParameters<Boolean, C>(table2, value, row, column, isSelected, hasFocus);
    }

    @Override
    public final void validate() {
    }

    @Override
    public final void invalidate() {
    }

    @Override
    public final void revalidate() {
    }

    @Override
    public final void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public final void repaint(Rectangle r) {
    }

    @Override
    public final void repaint() {
    }

    protected void checkPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (Objects.equals((Object)propertyName, "styleId", "parent", "decorationStates", "styleRanges", "text", "border", "model")) {
            this.allowPropertyChange(propertyName, oldValue, newValue);
        } else if (Objects.equals((Object)propertyName, "font", "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
            this.allowPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void allowPropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, char oldValue, char newValue) {
        this.checkPropertyChange(propertyName, Character.valueOf(oldValue), Character.valueOf(newValue));
    }

    @Override
    public final void firePropertyChange(String propertyName, short oldValue, short newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.checkPropertyChange(propertyName, Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    @Override
    public final void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    public static final class UIResource<C extends JTable, P extends TableCellParameters<Boolean, C>>
    extends WebTableBooleanCellRenderer<C, P>
    implements javax.swing.plaf.UIResource {
    }
}

