/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.AbstractComponentBehavior;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableRowHeightOptimizer
extends AbstractComponentBehavior<JTable>
implements PropertyChangeListener,
TableModelListener {
    protected int initialRowHeight;
    protected boolean adjusting;

    public TableRowHeightOptimizer(@NotNull JTable table2) {
        super(table2);
    }

    public void install() {
        this.initialRowHeight = ((JTable)this.component).getRowHeight();
        this.optimizeRowHeight();
        if (((JTable)this.component).getModel() != null) {
            ((JTable)this.component).getModel().addTableModelListener(this);
        }
        ((JTable)this.component).addPropertyChangeListener(this);
    }

    public void uninstall() {
        ((JTable)this.component).removePropertyChangeListener(this);
        if (((JTable)this.component).getModel() != null) {
            ((JTable)this.component).getModel().removeTableModelListener(this);
        }
        this.restoreRowHeight();
        this.initialRowHeight = 0;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (Objects.equals((Object)propertyName, (Object)"model")) {
            TableModel newModel;
            TableModel oldModel = (TableModel)event.getOldValue();
            if (oldModel != null) {
                oldModel.removeTableModelListener(this);
            }
            if ((newModel = (TableModel)event.getNewValue()) != null) {
                newModel.addTableModelListener(this);
            }
            this.optimizeRowHeight();
        } else if (Objects.equals((Object)propertyName, (Object)"rowHeight") && !this.adjusting) {
            this.initialRowHeight = ((JTable)this.component).getRowHeight();
            this.optimizeRowHeight();
        }
    }

    @Override
    public void tableChanged(@NotNull TableModelEvent event) {
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableRowHeightOptimizer.this.optimizeRowHeight();
            }
        });
    }

    protected void optimizeRowHeight() {
        TableModel model;
        int maxHeight = this.initialRowHeight;
        if (((JTable)this.component).getColumnCount() > 0 && (model = ((JTable)this.component).getModel()).getRowCount() > 0) {
            Rectangle vr = ((JTable)this.component).getVisibleRect();
            if (vr.width > 0 && vr.height > 0) {
                boolean ltr = ((JTable)this.component).getComponentOrientation().isLeftToRight();
                Point upperLeft = new Point(ltr ? vr.x + 1 : vr.x + vr.width - 1, vr.y + 1);
                Point lowerLeft = new Point(ltr ? vr.x + 1 : vr.x + vr.width - 1, vr.y + vr.height - 1);
                Point upperRight = new Point(ltr ? vr.x + vr.width - 1 : vr.x + 1, vr.y + 1);
                int rMin = Math.max(0, ((JTable)this.component).rowAtPoint(upperLeft));
                int rMax = Math.min(((JTable)this.component).getRowCount() - 1, ((JTable)this.component).rowAtPoint(lowerLeft));
                int cMin = Math.max(0, ((JTable)this.component).columnAtPoint(upperLeft));
                int cMax = Math.min(((JTable)this.component).getColumnCount() - 1, ((JTable)this.component).columnAtPoint(upperRight));
                for (int row = rMin; row <= rMax; ++row) {
                    for (int col = cMin; col < cMax; ++col) {
                        Component renderer = this.prepareRenderer(model, row, col);
                        Dimension ps = renderer.getPreferredSize();
                        maxHeight = Math.max(maxHeight, ps.height);
                    }
                }
            } else {
                for (int col = 0; col < ((JTable)this.component).getColumnCount(); ++col) {
                    Component renderer = this.prepareRenderer(model, 0, col);
                    Dimension ps = renderer.getPreferredSize();
                    maxHeight = Math.max(maxHeight, ps.height);
                }
            }
        }
        if (maxHeight != ((JTable)this.component).getRowHeight()) {
            this.adjusting = true;
            ((JTable)this.component).setRowHeight(maxHeight);
            this.adjusting = false;
        }
    }

    @NotNull
    protected Component prepareRenderer(@NotNull TableModel model, int row, int col) {
        TableCellRenderer cellRenderer = ((JTable)this.component).getCellRenderer(row, col);
        Component renderer = ((JTable)this.component).getRowCount() > 0 ? ((JTable)this.component).prepareRenderer(cellRenderer, row, col) : cellRenderer.getTableCellRendererComponent((JTable)this.component, model.getValueAt(row, col), false, false, row, col);
        return renderer;
    }

    protected void restoreRowHeight() {
        this.adjusting = true;
        ((JTable)this.component).setRowHeight(this.initialRowHeight);
        this.adjusting = false;
    }
}

