/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.tabbedpane.Tab;
import com.alee.laf.tabbedpane.WTabbedPaneUI;
import com.alee.managers.tooltip.AbstractComponentArea;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public class TabbedPaneTabArea<V, C extends JTabbedPane>
extends AbstractComponentArea<V, C> {
    protected final int tab;

    public TabbedPaneTabArea(int tab) {
        this.tab = tab;
    }

    public int tab() {
        return this.tab;
    }

    @Override
    public boolean isAvailable(@NotNull C component2) {
        return 0 <= this.tab && this.tab < ((JTabbedPane)component2).getTabCount();
    }

    @Override
    @Nullable
    public Rectangle getBounds(@NotNull C component2) {
        TabbedPaneUI ui;
        Rectangle bounds = ((JTabbedPane)component2).getBoundsAt(this.tab);
        if (bounds != null && (ui = ((JTabbedPane)component2).getUI()) instanceof WTabbedPaneUI) {
            Tab tab = ((WTabbedPaneUI)ui).getTab(this.tab);
            this.adjustBounds(component2, (Component)tab, bounds);
        }
        return bounds;
    }

    @Override
    @Nullable
    public V getValue(@NotNull C component2) {
        return (V)((JTabbedPane)component2).getComponentAt(this.tab);
    }

    @Override
    protected void adjustBounds(@NotNull C component2, @NotNull Component content, @NotNull Rectangle bounds) {
        if (content instanceof Tab) {
            Tab tab = (Tab)content;
            if (tab.getComponent() == null) {
                int align = tab.getHorizontalAlignment();
                this.adjustBounds(component2, tab, bounds, align);
            } else {
                Component tabComponent = tab.getComponent();
                Rectangle tabComponentBounds = tabComponent.getBounds();
                tabComponentBounds.x += bounds.x;
                tabComponentBounds.y += bounds.y;
                this.adjustBounds(component2, tabComponent, tabComponentBounds);
            }
        } else {
            super.adjustBounds(component2, content, bounds);
        }
    }

    public boolean equals(Object other) {
        return other instanceof TabbedPaneTabArea && this.tab == ((TabbedPaneTabArea)other).tab;
    }
}

