/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.merge.Mergeable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.tabbedpane.Tab;
import com.alee.laf.tabbedpane.TabArea;
import com.alee.laf.tabbedpane.TabContainer;
import com.alee.laf.tabbedpane.WTabbedPaneUI;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.StyleException;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.ComponentSize;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JTabbedPane;

@XStreamAlias(value="TabbedPaneLayout")
public class TabbedPaneLayout
extends AbstractLayoutManager
implements Mergeable,
Cloneable,
Serializable {
    @XStreamAlias(value="ContentSize")
    protected ComponentSize contentSize;
    protected transient Rectangle contentBounds = null;

    @NotNull
    public ComponentSize getContentSize() {
        if (this.contentSize == null) {
            throw new StyleException("ContentSize must be specified for TabbedPaneLayout");
        }
        return this.contentSize;
    }

    @NotNull
    public Rectangle getContentBounds() {
        return this.contentBounds != null ? new Rectangle(this.contentBounds) : new Rectangle();
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        Component selectedComponent;
        JTabbedPane tabbedPane = (JTabbedPane)parent;
        Rectangle contentBounds = BoundsType.padding.bounds(tabbedPane);
        TabArea tabArea = this.getTabArea(tabbedPane);
        if (tabArea != null && tabArea.isVisible()) {
            boolean ltr = tabbedPane.getComponentOrientation().isLeftToRight();
            Dimension tabAreaSize = tabArea.getPreferredSize();
            int tabPlacement = tabbedPane.getTabPlacement();
            if (tabPlacement == 1) {
                tabArea.setBounds(contentBounds.x, contentBounds.y, contentBounds.width, tabAreaSize.height);
                contentBounds.y += tabAreaSize.height;
                contentBounds.height -= Math.min(tabAreaSize.height, contentBounds.height);
            } else if (tabPlacement == 3) {
                tabArea.setBounds(contentBounds.x, contentBounds.y + contentBounds.height - tabAreaSize.height, contentBounds.width, tabAreaSize.height);
                contentBounds.height -= Math.min(tabAreaSize.height, contentBounds.height);
            } else if (tabPlacement == (ltr ? 2 : 4)) {
                tabArea.setBounds(contentBounds.x, contentBounds.y, tabAreaSize.width, contentBounds.height);
                contentBounds.x += tabAreaSize.width;
                contentBounds.width -= Math.min(tabAreaSize.width, contentBounds.width);
            } else if (tabPlacement == (ltr ? 4 : 2)) {
                tabArea.setBounds(contentBounds.x + contentBounds.width - tabAreaSize.width, contentBounds.y, tabAreaSize.width, contentBounds.height);
                contentBounds.width -= Math.min(tabAreaSize.width, contentBounds.width);
            }
        }
        if ((selectedComponent = tabbedPane.getSelectedComponent()) != null) {
            selectedComponent.setVisible(true);
            this.contentBounds = contentBounds;
            selectedComponent.setBounds(SwingUtils.shrink(contentBounds, this.getContentSize().getInsets()));
        } else {
            for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                Component componentAt = tabbedPane.getComponentAt(i);
                if (componentAt == null || !componentAt.isVisible()) continue;
                componentAt.setVisible(false);
            }
            this.contentBounds = BoundsType.padding.bounds(tabbedPane);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Dimension preferredSize;
        JTabbedPane tabbedPane = (JTabbedPane)parent;
        ComponentSize contentSize = this.getContentSize();
        Dimension contentPreferredSize = new Dimension(0, 0);
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Component componentAt = tabbedPane.getComponentAt(i);
            if (componentAt == null) continue;
            contentPreferredSize = SwingUtils.maxNonNull(contentPreferredSize, contentSize.size(componentAt));
        }
        TabArea tabArea = this.getTabArea(tabbedPane);
        if (tabArea != null && tabArea.isVisible()) {
            Dimension tabAreaSize = tabArea.getPreferredSize();
            switch (tabbedPane.getTabPlacement()) {
                default: {
                    preferredSize = new Dimension(Math.max(tabAreaSize.width, contentPreferredSize.width), tabAreaSize.height + contentPreferredSize.height);
                    break;
                }
                case 2: 
                case 4: {
                    preferredSize = new Dimension(tabAreaSize.width + contentPreferredSize.width, Math.max(tabAreaSize.height, contentPreferredSize.height));
                    break;
                }
            }
        } else {
            preferredSize = contentPreferredSize;
        }
        SwingUtils.increase(preferredSize, tabbedPane.getInsets());
        return preferredSize;
    }

    @Override
    public void invalidateLayout(@NotNull Container container) {
        TabContainer tabContainer;
        WTabbedPaneUI ui;
        JTabbedPane tabbedPane = (JTabbedPane)container;
        if (!(tabbedPane instanceof WebTabbedPane) && (ui = (WTabbedPaneUI)LafUtils.getUI(tabbedPane)) != null && (tabContainer = ui.getTabContainer()) != null && tabContainer.getComponentCount() == tabbedPane.getTabCount()) {
            for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                Tab tab = (Tab)tabContainer.getComponent(i);
                if (tab.getForeground() != tabbedPane.getForegroundAt(i)) {
                    SwingUtils.firePropertyChanged(tabbedPane, "foregroundAt", null, i);
                }
                if (tab.getBackground() != tabbedPane.getBackgroundAt(i)) {
                    SwingUtils.firePropertyChanged(tabbedPane, "backgroundAt", null, i);
                }
                if (tab.isEnabled() != tabbedPane.isEnabledAt(i)) {
                    SwingUtils.firePropertyChanged(tabbedPane, "enabledAt", null, i);
                }
                if (tab.getIcon() != tabbedPane.getIconAt(i)) {
                    SwingUtils.firePropertyChanged(tabbedPane, "iconAt", null, i);
                }
                if (tabbedPane.isEnabledAt(i) || tab.getDisabledIcon() == tabbedPane.getDisabledIconAt(i)) continue;
                SwingUtils.firePropertyChanged(tabbedPane, "disabledIconAt", null, i);
            }
        }
    }

    @Nullable
    protected TabArea getTabArea(@NotNull JTabbedPane tabbedPane) {
        return SwingUtils.getFirst(tabbedPane, TabArea.class);
    }

    @XStreamAlias(value="TabbedPaneLayout$UIResource")
    public static final class UIResource
    extends TabbedPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

