/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.menu.WebRadioButtonMenuItem;
import com.alee.laf.tabbedpane.Tab;
import com.alee.laf.tabbedpane.TabComponent;
import com.alee.laf.tabbedpane.WTabbedPaneUI;
import com.alee.managers.language.LM;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.style.StyleId;
import com.alee.utils.LafUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;

public class TabMenuItem
extends WebRadioButtonMenuItem
implements ActionListener,
UIResource {
    @NotNull
    protected final JTabbedPane tabbedPane;
    protected final int index;

    public TabMenuItem(@NotNull JTabbedPane tabbedPane, @NotNull WebPopupMenu menu, int index) {
        super(StyleId.tabbedpaneTabMenuItem.at(menu));
        String title;
        Icon icon;
        this.tabbedPane = tabbedPane;
        this.index = index;
        this.setEnabled(tabbedPane.isEnabledAt(index));
        this.setSelected(tabbedPane.getSelectedIndex() == index);
        WTabbedPaneUI ui = (WTabbedPaneUI)LafUtils.getUI(tabbedPane);
        if (ui != null) {
            Tab tab = ui.getTab(index);
            if (tab.getComponent() instanceof TabComponent) {
                TabComponent tabComponent = (TabComponent)((Object)tab.getComponent());
                icon = tabComponent.getIcon();
                title = tabComponent instanceof JComponent && UILanguageManager.isRegisteredComponent((JComponent)((Object)tabComponent)) ? UILanguageManager.getComponentKey((JComponent)((Object)tabComponent)) : tabComponent.getTitle();
            } else {
                icon = tab.getIcon();
                title = UILanguageManager.isRegisteredComponent(tab) ? UILanguageManager.getComponentKey(tab) : tab.getText();
            }
        } else {
            icon = tabbedPane.getIconAt(index);
            title = tabbedPane.getTitleAt(index);
        }
        this.setIcon(icon);
        if (icon != null || title != null) {
            if (title != null && LM.contains(title)) {
                this.setLanguage(title, new Object[0]);
            } else {
                this.setText(title);
            }
        } else {
            this.setLanguage("weblaf.tabbedpane.menu.tab", index + 1);
        }
        this.addActionListener(this);
    }

    @NotNull
    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.tabbedPane.setSelectedIndex(this.index);
    }
}

