/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.laf.button.WebButton;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.tabbedpane.TabArea;
import com.alee.laf.tabbedpane.TabMenuItem;
import com.alee.managers.style.StyleId;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;

public class TabMenuButton
extends WebButton
implements ActionListener,
UIResource {
    protected final JTabbedPane tabbedPane;

    public TabMenuButton(@NotNull JTabbedPane tabbedPane, @NotNull TabArea tabArea) {
        super(StyleId.tabbedpaneTabMenuButton.at(tabArea));
        this.tabbedPane = tabbedPane;
        this.addActionListener(this);
    }

    @NotNull
    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        WebPopupMenu menu = new WebPopupMenu(StyleId.tabbedpaneTabMenu.at(this));
        ButtonGroup group = new ButtonGroup();
        for (int tabIndex = 0; tabIndex < this.tabbedPane.getTabCount(); ++tabIndex) {
            TabMenuItem menuItem = new TabMenuItem(this.tabbedPane, menu, tabIndex);
            menu.add(menuItem);
            group.add(menuItem);
        }
        boolean ltr = this.tabbedPane.getComponentOrientation().isLeftToRight();
        Dimension menuSize = menu.getPreferredSize();
        if (this.tabbedPane.getTabPlacement() == 1) {
            menu.show(this, ltr ? this.getWidth() - menuSize.width : 0, this.getHeight());
        } else if (this.tabbedPane.getTabPlacement() == 3) {
            menu.show(this, ltr ? this.getWidth() - menuSize.width : 0, -menuSize.height);
        } else if (ltr && this.tabbedPane.getTabPlacement() == 2 || !ltr && this.tabbedPane.getTabPlacement() == 4) {
            menu.show(this, this.getWidth(), this.getHeight() - menuSize.height);
        } else if (ltr && this.tabbedPane.getTabPlacement() == 4 || !ltr && this.tabbedPane.getTabPlacement() == 2) {
            menu.show(this, -menuSize.width, this.getHeight() - menuSize.height);
        }
    }
}

