/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.WebContainer;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.button.WebButton;
import com.alee.laf.splitpane.WSplitPaneDividerUI;
import com.alee.laf.splitpane.WSplitPaneUI;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class WebSplitPaneDivider
extends WebContainer<WebSplitPaneDivider, WSplitPaneDividerUI>
implements PropertyChangeListener {
    public static final String SPLIT_PANE_PROPERTY = "splitPane";
    protected transient JSplitPane splitPane;
    protected transient WSplitPaneUI splitPaneUI;
    protected transient MouseHandler mouseHandler;
    protected transient DragController dragger;
    protected int dividerSize = 0;
    protected Component hiddenDivider;
    protected int orientation;
    protected WebButton leftButton;
    protected WebButton rightButton;

    public WebSplitPaneDivider(JSplitPane splitPane) {
        this(StyleId.auto, splitPane);
    }

    public WebSplitPaneDivider(StyleId id, JSplitPane splitPane) {
        this.setLayout(new DividerLayout());
        this.setSplitPane(splitPane);
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.splitpanedivider;
    }

    protected void setSplitPane(JSplitPane splitPane) {
        JSplitPane old = this.splitPane;
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPane = splitPane;
        WSplitPaneUI wSplitPaneUI = this.splitPaneUI = splitPane != null ? (WSplitPaneUI)splitPane.getUI() : null;
        if (this.splitPane != null) {
            this.updateOrientationAndCursor();
            if (this.mouseHandler == null) {
                this.mouseHandler = new MouseHandler();
            }
            this.splitPane.addMouseListener(this.mouseHandler);
            this.splitPane.addMouseMotionListener(this.mouseHandler);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
            this.splitPane.addPropertyChangeListener(this);
            if (this.splitPane.isOneTouchExpandable()) {
                this.updateOneTouchButtons();
            }
        }
        this.firePropertyChange(SPLIT_PANE_PROPERTY, old, this.splitPane);
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public WSplitPaneUI getSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int size) {
        this.dividerSize = size;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.splitPane) {
            if (e.getPropertyName().equals("orientation")) {
                this.updateOrientationAndCursor();
                this.updateOneTouchButtons();
            } else if (e.getPropertyName().equals("oneTouchExpandable")) {
                this.updateOneTouchButtons();
            }
        }
    }

    protected void updateOrientationAndCursor() {
        this.orientation = this.splitPane.getOrientation();
        this.setCursor(this.orientation == 1 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9));
    }

    protected void updateOneTouchButtons() {
        if (this.splitPane.isOneTouchExpandable()) {
            if (this.leftButton == null && this.rightButton == null) {
                this.leftButton = this.createLeftOneTouchButton();
                this.rightButton = this.createRightOneTouchButton();
                this.add((Component)this.leftButton);
                this.add((Component)this.rightButton);
            } else {
                DecorationUtils.fireStatesChanged(this.leftButton);
                DecorationUtils.fireStatesChanged(this.rightButton);
            }
        }
        this.revalidate();
    }

    protected WebButton createLeftOneTouchButton() {
        OneTouchButton button = new OneTouchButton(StyleId.splitpanedividerOneTouchLeftButton.at(this));
        button.addActionListener(new OneTouchActionHandler(true));
        return button;
    }

    protected WebButton createRightOneTouchButton() {
        OneTouchButton button = new OneTouchButton(StyleId.splitpanedividerOneTouchRightButton.at(this));
        button.addActionListener(new OneTouchActionHandler(false));
        return button;
    }

    protected void prepareForDragging() {
        this.splitPaneUI.startDragging();
    }

    protected void dragDividerTo(int location) {
        this.splitPaneUI.dragDividerTo(location);
    }

    protected void finishDraggingTo(int location) {
        this.splitPaneUI.finishDraggingTo(location);
    }

    @Override
    public WSplitPaneDividerUI getUI() {
        return (WSplitPaneDividerUI)this.ui;
    }

    public void setUI(WSplitPaneDividerUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }

    protected class OneTouchActionHandler
    implements ActionListener {
        private final boolean toMinimum;

        public OneTouchActionHandler(boolean toMinimum) {
            this.toMinimum = toMinimum;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int newLoc;
            Insets insets = WebSplitPaneDivider.this.splitPane.getInsets();
            int lastLoc = WebSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int currentLoc = WebSplitPaneDivider.this.splitPaneUI.getDividerLocation(WebSplitPaneDivider.this.splitPane);
            if (this.toMinimum) {
                if (WebSplitPaneDivider.this.orientation == 0) {
                    if (currentLoc >= WebSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - WebSplitPaneDivider.this.getHeight()) {
                        int maxLoc = WebSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                        newLoc = Math.min(lastLoc, maxLoc);
                        WebSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                    } else {
                        newLoc = insets.top;
                        WebSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                    }
                } else if (currentLoc >= WebSplitPaneDivider.this.splitPane.getWidth() - insets.right - WebSplitPaneDivider.this.getWidth()) {
                    int maxLoc = WebSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                    newLoc = Math.min(lastLoc, maxLoc);
                    WebSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                } else {
                    newLoc = insets.left;
                    WebSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                }
            } else if (WebSplitPaneDivider.this.orientation == 0) {
                if (currentLoc == insets.top) {
                    int maxLoc = WebSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                    newLoc = Math.min(lastLoc, maxLoc);
                    WebSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                } else {
                    newLoc = WebSplitPaneDivider.this.splitPane.getHeight() - WebSplitPaneDivider.this.getHeight() - insets.top;
                    WebSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                }
            } else if (currentLoc == insets.left) {
                int maxLoc = WebSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                newLoc = Math.min(lastLoc, maxLoc);
                WebSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
            } else {
                newLoc = WebSplitPaneDivider.this.splitPane.getWidth() - WebSplitPaneDivider.this.getWidth() - insets.left;
                WebSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
            }
            if (currentLoc != newLoc) {
                WebSplitPaneDivider.this.splitPane.setDividerLocation(newLoc);
                WebSplitPaneDivider.this.splitPane.setLastDividerLocation(currentLoc);
            }
        }
    }

    protected class DividerLayout
    extends AbstractLayoutManager {
        protected DividerLayout() {
        }

        @Override
        public void layoutContainer(@NotNull Container container) {
            if (WebSplitPaneDivider.this.leftButton != null && WebSplitPaneDivider.this.rightButton != null && container == WebSplitPaneDivider.this) {
                if (WebSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = WebSplitPaneDivider.this.getInsets();
                    Dimension lps = WebSplitPaneDivider.this.leftButton.getPreferredSize();
                    Dimension rps = WebSplitPaneDivider.this.rightButton.getPreferredSize();
                    if (WebSplitPaneDivider.this.orientation == 0) {
                        int y;
                        boolean ltr = WebSplitPaneDivider.this.getComponentOrientation().isLeftToRight();
                        int dividerHeight = WebSplitPaneDivider.this.getHeight() - (insets != null ? insets.top + insets.bottom : 0);
                        int n = y = insets != null ? insets.top : 0;
                        if (ltr) {
                            int x = insets != null ? insets.left : 0;
                            WebSplitPaneDivider.this.leftButton.setBounds(x, y, lps.width, dividerHeight);
                            WebSplitPaneDivider.this.rightButton.setBounds(x + lps.width, y, rps.width, dividerHeight);
                        } else {
                            int x = WebSplitPaneDivider.this.getWidth() - lps.width - rps.width - (insets != null ? insets.right : 0);
                            WebSplitPaneDivider.this.rightButton.setBounds(x, y, rps.width, dividerHeight);
                            WebSplitPaneDivider.this.leftButton.setBounds(x + rps.width, y, lps.width, dividerHeight);
                        }
                    } else {
                        int x = insets != null ? insets.left : 0;
                        int y = insets != null ? insets.top : 0;
                        int dividerWidth = WebSplitPaneDivider.this.getWidth() - (insets != null ? insets.left + insets.right : 0);
                        WebSplitPaneDivider.this.leftButton.setBounds(x, y, dividerWidth, lps.height);
                        WebSplitPaneDivider.this.rightButton.setBounds(x, y + lps.height, dividerWidth, rps.height);
                    }
                    WebSplitPaneDivider.this.leftButton.setVisible(true);
                    WebSplitPaneDivider.this.rightButton.setVisible(true);
                } else {
                    WebSplitPaneDivider.this.leftButton.setVisible(false);
                    WebSplitPaneDivider.this.rightButton.setVisible(false);
                }
            }
        }

        @Override
        @NotNull
        public Dimension minimumLayoutSize(@NotNull Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container container) {
            Dimension ps;
            if (container == WebSplitPaneDivider.this && WebSplitPaneDivider.this.splitPane != null) {
                Dimension buttonSize = null;
                if (WebSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    if (WebSplitPaneDivider.this.leftButton != null) {
                        buttonSize = WebSplitPaneDivider.this.leftButton.getPreferredSize();
                    }
                    if (WebSplitPaneDivider.this.rightButton != null) {
                        buttonSize = SwingUtils.max(buttonSize, WebSplitPaneDivider.this.rightButton.getPreferredSize());
                    }
                }
                Insets insets = WebSplitPaneDivider.this.getInsets();
                int dividerWidth = WebSplitPaneDivider.this.getDividerSize();
                if (WebSplitPaneDivider.this.orientation == 0) {
                    if (buttonSize != null) {
                        int size = buttonSize.height;
                        if (insets != null) {
                            size += insets.top + insets.bottom;
                        }
                        dividerWidth = Math.max(dividerWidth, size);
                    }
                    ps = new Dimension(1, dividerWidth);
                } else {
                    if (buttonSize != null) {
                        int size = buttonSize.width;
                        if (insets != null) {
                            size += insets.left + insets.right;
                        }
                        dividerWidth = Math.max(dividerWidth, size);
                    }
                    ps = new Dimension(dividerWidth, 1);
                }
            } else {
                ps = new Dimension(0, 0);
            }
            return ps;
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent event) {
            super(event);
            JSplitPane splitPane = WebSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Component leftC = splitPane.getLeftComponent();
            Component rightC = splitPane.getRightComponent();
            this.initialX = WebSplitPaneDivider.this.getLocation().y;
            this.offset = event.getSource() == WebSplitPaneDivider.this ? event.getY() : event.getY() - this.initialX;
            if (leftC == null || rightC == null || this.offset < -1 || this.offset > WebSplitPaneDivider.this.getSize().height) {
                this.maxX = -1;
            } else {
                Insets insets = splitPane.getInsets();
                if (leftC.isVisible()) {
                    this.minX = leftC.getMinimumSize().height;
                    if (insets != null) {
                        this.minX += insets.top;
                    }
                } else {
                    this.minX = 0;
                }
                if (rightC.isVisible()) {
                    int bottom = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, splitPane.getSize().height - (WebSplitPaneDivider.this.getSize().height + bottom) - rightC.getMinimumSize().height);
                } else {
                    int bottom = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, splitPane.getSize().height - (WebSplitPaneDivider.this.getSize().height + bottom));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        @Override
        protected int getNeededLocation(int x, int y) {
            int newY = Math.min(this.maxX, Math.max(this.minX, y - this.offset));
            return newY;
        }

        @Override
        protected int positionForMouseEvent(MouseEvent e) {
            int newY = e.getSource() == WebSplitPaneDivider.this ? e.getY() + WebSplitPaneDivider.this.getLocation().y : e.getY();
            newY = Math.min(this.maxX, Math.max(this.minX, newY - this.offset));
            return newY;
        }
    }

    protected class DragController {
        protected int initialX;
        protected int maxX;
        protected int minX;
        protected int offset;

        protected DragController(MouseEvent event) {
            JSplitPane splitPane = WebSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Component leftC = splitPane.getLeftComponent();
            Component rightC = splitPane.getRightComponent();
            this.initialX = WebSplitPaneDivider.this.getLocation().x;
            this.offset = event.getSource() == WebSplitPaneDivider.this ? event.getX() : event.getX() - this.initialX;
            if (leftC == null || rightC == null || this.offset < -1 || this.offset >= WebSplitPaneDivider.this.getSize().width) {
                this.maxX = -1;
            } else {
                Insets insets = splitPane.getInsets();
                if (leftC.isVisible()) {
                    this.minX = leftC.getMinimumSize().width;
                    if (insets != null) {
                        this.minX += insets.left;
                    }
                } else {
                    this.minX = 0;
                }
                if (rightC.isVisible()) {
                    int right = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, splitPane.getSize().width - (WebSplitPaneDivider.this.getSize().width + right) - rightC.getMinimumSize().width);
                } else {
                    int right = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, splitPane.getSize().width - (WebSplitPaneDivider.this.getSize().width + right));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        protected boolean isValid() {
            return this.maxX > 0;
        }

        protected int positionForMouseEvent(MouseEvent event) {
            int newX = event.getSource() == WebSplitPaneDivider.this ? event.getX() + WebSplitPaneDivider.this.getLocation().x : event.getX();
            newX = Math.min(this.maxX, Math.max(this.minX, newX - this.offset));
            return newX;
        }

        protected int getNeededLocation(int x, int y) {
            return Math.min(this.maxX, Math.max(this.minX, x - this.offset));
        }

        protected void continueDrag(int newX, int newY) {
            WebSplitPaneDivider.this.dragDividerTo(this.getNeededLocation(newX, newY));
        }

        protected void continueDrag(MouseEvent event) {
            WebSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(event));
        }

        protected void completeDrag(int x, int y) {
            WebSplitPaneDivider.this.finishDraggingTo(this.getNeededLocation(x, y));
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((e.getSource() == WebSplitPaneDivider.this || e.getSource() == WebSplitPaneDivider.this.splitPane) && WebSplitPaneDivider.this.dragger == null && WebSplitPaneDivider.this.splitPane.isEnabled()) {
                JComponent newHiddenDivider = WebSplitPaneDivider.this.splitPaneUI.getNonContinuousLayoutDivider();
                if (WebSplitPaneDivider.this.hiddenDivider != newHiddenDivider) {
                    if (WebSplitPaneDivider.this.hiddenDivider != null) {
                        WebSplitPaneDivider.this.hiddenDivider.removeMouseListener(this);
                        WebSplitPaneDivider.this.hiddenDivider.removeMouseMotionListener(this);
                    }
                    WebSplitPaneDivider.this.hiddenDivider = newHiddenDivider;
                    if (WebSplitPaneDivider.this.hiddenDivider != null) {
                        WebSplitPaneDivider.this.hiddenDivider.addMouseMotionListener(this);
                        WebSplitPaneDivider.this.hiddenDivider.addMouseListener(this);
                    }
                }
                if (WebSplitPaneDivider.this.splitPane.getLeftComponent() != null && WebSplitPaneDivider.this.splitPane.getRightComponent() != null) {
                    WebSplitPaneDivider.this.dragger = WebSplitPaneDivider.this.orientation == 1 ? new DragController(e) : new VerticalDragController(e);
                    if (!WebSplitPaneDivider.this.dragger.isValid()) {
                        WebSplitPaneDivider.this.dragger = null;
                    } else {
                        WebSplitPaneDivider.this.prepareForDragging();
                        WebSplitPaneDivider.this.dragger.continueDrag(e);
                    }
                }
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (WebSplitPaneDivider.this.dragger != null) {
                if (e.getSource() == WebSplitPaneDivider.this.splitPane) {
                    WebSplitPaneDivider.this.dragger.completeDrag(e.getX(), e.getY());
                } else if (e.getSource() == WebSplitPaneDivider.this) {
                    Point ourLoc = WebSplitPaneDivider.this.getLocation();
                    WebSplitPaneDivider.this.dragger.completeDrag(e.getX() + ourLoc.x, e.getY() + ourLoc.y);
                } else if (e.getSource() == WebSplitPaneDivider.this.hiddenDivider) {
                    Point hDividerLoc = WebSplitPaneDivider.this.hiddenDivider.getLocation();
                    int ourX = e.getX() + hDividerLoc.x;
                    int ourY = e.getY() + hDividerLoc.y;
                    WebSplitPaneDivider.this.dragger.completeDrag(ourX, ourY);
                }
                WebSplitPaneDivider.this.dragger = null;
                e.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (WebSplitPaneDivider.this.dragger != null) {
                if (e.getSource() == WebSplitPaneDivider.this.splitPane) {
                    WebSplitPaneDivider.this.dragger.continueDrag(e.getX(), e.getY());
                } else if (e.getSource() == WebSplitPaneDivider.this) {
                    Point ourLoc = WebSplitPaneDivider.this.getLocation();
                    WebSplitPaneDivider.this.dragger.continueDrag(e.getX() + ourLoc.x, e.getY() + ourLoc.y);
                } else if (e.getSource() == WebSplitPaneDivider.this.hiddenDivider) {
                    Point hDividerLoc = WebSplitPaneDivider.this.hiddenDivider.getLocation();
                    int ourX = e.getX() + hDividerLoc.x;
                    int ourY = e.getY() + hDividerLoc.y;
                    WebSplitPaneDivider.this.dragger.continueDrag(ourX, ourY);
                }
                e.consume();
            }
        }
    }

    public class OneTouchButton
    extends WebButton
    implements Stateful {
        public OneTouchButton(StyleId id) {
            super(id);
        }

        @Override
        @Nullable
        public List<String> getStates() {
            ArrayList<String> states;
            JSplitPane splitPane = WebSplitPaneDivider.this.getSplitPane();
            if (splitPane != null) {
                states = new ArrayList<String>(1);
                boolean vertical = splitPane.getOrientation() == 1;
                states.add(vertical ? "vertical" : "horizontal");
                if (splitPane.isOneTouchExpandable()) {
                    states.add("one-touch");
                }
            } else {
                states = null;
            }
            return states;
        }
    }
}

