/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.splitpane.SplitPaneState;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;

public class SplitPaneSettingsProcessor
extends SettingsProcessor<JSplitPane, SplitPaneState, Configuration<SplitPaneState>> {
    protected transient PropertyChangeListener propertyChangeListener;

    public SplitPaneSettingsProcessor(JSplitPane splitPane, Configuration configuration) {
        super(splitPane, configuration);
    }

    @Override
    protected void register(@NotNull JSplitPane splitPane) {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SplitPaneSettingsProcessor.this.save();
            }
        };
        splitPane.addPropertyChangeListener("dividerLocation", this.propertyChangeListener);
    }

    @Override
    protected void unregister(@NotNull JSplitPane splitPane) {
        splitPane.removePropertyChangeListener("dividerLocation", this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    @Nullable
    protected SplitPaneState createDefaultValue() {
        return new SplitPaneState((JSplitPane)this.component());
    }

    @Override
    protected void loadSettings(@NotNull JSplitPane splitPane) {
        ((SplitPaneState)this.loadSettings()).apply(splitPane);
    }

    @Override
    protected void saveSettings(@NotNull JSplitPane splitPane) {
        this.saveSettings(new SplitPaneState(splitPane));
    }
}

