/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.spinner;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.button.WebButton;
import com.alee.laf.spinner.WebSpinnerLayout;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.JTextComponent;

public class WebSpinnerUI
extends BasicSpinnerUI {
    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebSpinnerUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.spinner);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.spinner);
        super.uninstallUI(c);
    }

    @Override
    @NotNull
    protected LayoutManager createLayout() {
        return new WebSpinnerLayout();
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        editor.setInheritsPopupMenu(true);
        if (editor instanceof JTextComponent) {
            this.configureEditor((JTextComponent)editor, this.spinner);
        } else if (editor instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor container = (JSpinner.DefaultEditor)editor;
            this.configureEditorContainer(container, this.spinner);
            this.configureEditor(container.getTextField(), this.spinner);
        }
        return editor;
    }

    protected void configureEditorContainer(@NotNull JSpinner.DefaultEditor container, @NotNull JSpinner spinner) {
        StyleId.spinnerEditorContainer.at(spinner).set(container);
    }

    protected void configureEditor(@NotNull JTextComponent field2, @NotNull JSpinner spinner) {
        StyleId.spinnerEditor.at(spinner).set(field2);
    }

    @Override
    @NotNull
    protected Component createNextButton() {
        WebButton nextButton = new WebButton(StyleId.spinnerNextButton.at(this.spinner), (Icon)Icons.upSmall);
        nextButton.setName("Spinner.nextButton");
        this.installNextButtonListeners(nextButton);
        return nextButton;
    }

    @Override
    @NotNull
    protected Component createPreviousButton() {
        WebButton prevButton = new WebButton(StyleId.spinnerPreviousButton.at(this.spinner), (Icon)Icons.downSmall);
        prevButton.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(prevButton);
        return prevButton;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return null;
    }
}

