/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.slider;

import com.alee.api.annotations.NotNull;
import com.alee.laf.slider.ISliderPainter;
import com.alee.laf.slider.SliderPaintParameters;
import com.alee.laf.slider.WebSliderUI;
import com.alee.managers.style.Bounds;
import com.alee.painter.AbstractPainter;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPainter<C extends JSlider, U extends WebSliderUI>
extends AbstractPainter<C, U>
implements ISliderPainter<C, U> {
    public static final int MAX_DARKNESS = 5;
    protected int trackHeight;
    protected int trackRound;
    protected int trackShadeWidth;
    protected int progressRound;
    protected int progressShadeWidth;
    protected int thumbWidth;
    protected int thumbHeight;
    protected int thumbRound;
    protected int thumbAngleLength;
    protected Color trackBgTop;
    protected Color trackBgBottom;
    protected Color progressTrackBgTop;
    protected Color progressTrackBgBottom;
    protected Color progressBorderColor;
    protected Color thumbBgTop;
    protected Color thumbBgBottom;
    protected boolean drawProgress;
    protected boolean drawThumb;
    protected boolean angledThumb;
    protected boolean sharpThumbAngle;
    protected boolean rolloverDarkBorderOnly;
    protected boolean animated;
    protected transient MouseWheelListener mouseWheelListener;
    protected transient ChangeListener changeListener;
    protected transient MouseAdapter mouseAdapter;
    protected transient boolean rollover = false;
    protected transient int rolloverDarkness = 0;
    protected transient WebTimer rolloverTimer;
    protected transient SliderPaintParameters paintParameters;
    protected transient int trackBuffer = 0;
    protected transient Rectangle focusRect = null;
    protected transient Rectangle contentRect = null;
    protected transient Rectangle labelRect = null;
    protected transient Rectangle tickRect = null;
    protected transient Rectangle trackRect = null;
    protected transient Rectangle thumbRect = null;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.focusRect = new Rectangle();
        this.contentRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.tickRect = new Rectangle();
        this.trackRect = new Rectangle();
        this.thumbRect = new Rectangle();
        this.mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (((JSlider)SliderPainter.this.component).isEnabled()) {
                    int v = ((JSlider)SliderPainter.this.component).getValue() - e.getWheelRotation();
                    ((JSlider)SliderPainter.this.component).setValue(MathUtils.limit(((JSlider)SliderPainter.this.component).getMinimum(), v, ((JSlider)SliderPainter.this.component).getMaximum()));
                }
            }
        };
        ((JSlider)this.component).addMouseWheelListener(this.mouseWheelListener);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderPainter.this.calculateThumbLocation();
                ((JSlider)SliderPainter.this.component).repaint();
            }
        };
        ((JSlider)this.component).addChangeListener(this.changeListener);
        this.rolloverTimer = new WebTimer("WebProgressBarUI.animator", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SliderPainter.this.rollover && SliderPainter.this.rolloverDarkness < 5) {
                    ++SliderPainter.this.rolloverDarkness;
                    ((JSlider)SliderPainter.this.component).repaint();
                } else if (!SliderPainter.this.rollover && SliderPainter.this.rolloverDarkness > 0) {
                    --SliderPainter.this.rolloverDarkness;
                    ((JSlider)SliderPainter.this.component).repaint();
                } else {
                    SliderPainter.this.rolloverTimer.stop();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((JSlider)SliderPainter.this.component).repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ((JSlider)SliderPainter.this.component).repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ((JSlider)SliderPainter.this.component).repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SliderPainter.this.rollover = true;
                if (SliderPainter.this.animated && ((JSlider)SliderPainter.this.component).isEnabled()) {
                    SliderPainter.this.rolloverTimer.start();
                } else {
                    SliderPainter.this.rolloverDarkness = 5;
                    ((JSlider)SliderPainter.this.component).repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SliderPainter.this.rollover = false;
                if (SliderPainter.this.animated && ((JSlider)SliderPainter.this.component).isEnabled()) {
                    SliderPainter.this.rolloverTimer.start();
                } else {
                    SliderPainter.this.rolloverDarkness = 0;
                    ((JSlider)SliderPainter.this.component).repaint();
                }
            }
        };
        ((JSlider)this.component).addMouseListener(this.mouseAdapter);
        ((JSlider)this.component).addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        ((JSlider)this.component).removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        ((JSlider)this.component).removeChangeListener(this.changeListener);
        this.changeListener = null;
        ((JSlider)this.component).removeMouseListener(this.mouseAdapter);
        ((JSlider)this.component).removeMouseMotionListener(this.mouseAdapter);
        this.mouseAdapter = null;
        this.focusRect = null;
        this.contentRect = null;
        this.labelRect = null;
        this.tickRect = null;
        this.trackRect = null;
        this.thumbRect = null;
        super.uninstallPropertiesAndListeners();
    }

    @Override
    public void prepareToPaint(@NotNull SliderPaintParameters parameters) {
        this.paintParameters = parameters;
    }

    @Override
    public void cleanupAfterPaint() {
        this.paintParameters = null;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Bounds bounds) {
        this.calculateGeometry();
        Rectangle clip = g2d.getClipBounds();
        if (((JSlider)this.component).getPaintTrack() && clip.intersects(this.trackRect)) {
            this.paintTrack(g2d);
        }
        if (((JSlider)this.component).getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g2d);
        }
        if (((JSlider)this.component).getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g2d);
        }
        if (clip.intersects(this.thumbRect)) {
            this.paintThumb(g2d);
        }
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        Insets insets = ((JSlider)this.component).getInsets();
        this.focusRect.x = insets.left;
        this.focusRect.y = insets.top;
        this.focusRect.width = ((JSlider)this.component).getWidth() - (insets.left + insets.right);
        this.focusRect.height = ((JSlider)this.component).getHeight() - (insets.top + insets.bottom);
    }

    protected void calculateThumbSize() {
        Dimension size = this.getThumbSize();
        this.thumbRect.setSize(size.width, size.height);
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x;
        this.contentRect.y = this.focusRect.y;
        this.contentRect.width = this.focusRect.width;
        this.contentRect.height = this.focusRect.height;
    }

    protected void calculateThumbLocation() {
        int valuePosition;
        if (((JSlider)this.component).getSnapToTicks()) {
            int sliderValue;
            int snappedValue = sliderValue = ((JSlider)this.component).getValue();
            int majorTickSpacing = ((JSlider)this.component).getMajorTickSpacing();
            int minorTickSpacing = ((JSlider)this.component).getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((sliderValue - ((JSlider)this.component).getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - ((JSlider)this.component).getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = ((JSlider)this.component).getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != sliderValue) {
                    ((JSlider)this.component).setValue(snappedValue);
                }
            }
        }
        if (((JSlider)this.component).getOrientation() == 0) {
            valuePosition = this.xPositionForValue(((JSlider)this.component).getValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            valuePosition = this.yPositionForValue(((JSlider)this.component).getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        if (((JSlider)this.component).getPaintLabels() && ((JSlider)this.component).getLabelTable() != null) {
            Component highLabel = this.getHighestValueLabel();
            Component lowLabel = this.getLowestValueLabel();
            if (((JSlider)this.component).getOrientation() == 0) {
                this.trackBuffer = Math.max(highLabel.getBounds().width, lowLabel.getBounds().width) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.width / 2);
            } else {
                this.trackBuffer = Math.max(highLabel.getBounds().height, lowLabel.getBounds().height) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.height / 2);
            }
        } else {
            this.trackBuffer = ((JSlider)this.component).getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackRect() {
        if (((JSlider)this.component).getOrientation() == 0) {
            int centerSpacing = this.thumbRect.height;
            if (((JSlider)this.component).getPaintTicks()) {
                centerSpacing += this.getTickLength();
            }
            if (((JSlider)this.component).getPaintLabels()) {
                centerSpacing += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - centerSpacing - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int centerSpacing = this.thumbRect.width;
            if (this.ltr) {
                if (((JSlider)this.component).getPaintTicks()) {
                    centerSpacing += this.getTickLength();
                }
                if (((JSlider)this.component).getPaintLabels()) {
                    centerSpacing += this.getWidthOfWidestLabel();
                }
            } else {
                if (((JSlider)this.component).getPaintTicks()) {
                    centerSpacing -= this.getTickLength();
                }
                if (((JSlider)this.component).getPaintLabels()) {
                    centerSpacing -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - centerSpacing - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (((JSlider)this.component).getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = ((JSlider)this.component).getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = ((JSlider)this.component).getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.ltr ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
    }

    protected void calculateLabelRect() {
        if (((JSlider)this.component).getPaintLabels()) {
            if (((JSlider)this.component).getOrientation() == 0) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                if (this.ltr) {
                    this.labelRect.x = this.tickRect.x + this.tickRect.width;
                    this.labelRect.width = this.getWidthOfWidestLabel();
                } else {
                    this.labelRect.width = this.getWidthOfWidestLabel();
                    this.labelRect.x = this.tickRect.x - this.labelRect.width;
                }
                this.labelRect.y = this.tickRect.y - this.trackBuffer;
                this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
            }
        } else if (((JSlider)this.component).getOrientation() == 0) {
            this.labelRect.x = this.tickRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.tickRect.width;
            this.labelRect.height = 0;
        } else {
            this.labelRect.x = this.ltr ? this.tickRect.x + this.tickRect.width : this.tickRect.x;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    protected int xPositionForValue(int value) {
        int xPosition;
        int min = ((JSlider)this.component).getMinimum();
        int max = ((JSlider)this.component).getMaximum();
        int trackLength = this.trackRect.width;
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackLength / valueRange;
        int trackLeft = this.trackRect.x;
        int trackRight = this.trackRect.x + this.trackRect.width - 1;
        if (!this.drawInverted()) {
            xPosition = trackLeft;
            xPosition = (int)((long)xPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        } else {
            xPosition = trackRight;
            xPosition = (int)((long)xPosition - Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        xPosition = Math.max(trackLeft, xPosition);
        xPosition = Math.min(trackRight, xPosition);
        return xPosition;
    }

    protected int yPositionForValue(int value) {
        return this.yPositionForValue(value, this.trackRect.y, this.trackRect.height);
    }

    protected int yPositionForValue(int value, int trackY, int trackHeight) {
        int yPosition;
        int min = ((JSlider)this.component).getMinimum();
        int max = ((JSlider)this.component).getMaximum();
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackHeight / valueRange;
        int trackBottom = trackY + trackHeight - 1;
        if (!this.drawInverted()) {
            yPosition = trackY;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)max - (double)value)));
        } else {
            yPosition = trackY;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        yPosition = Math.max(trackY, yPosition);
        yPosition = Math.min(trackBottom, yPosition);
        return yPosition;
    }

    protected boolean drawInverted() {
        if (((JSlider)this.component).getOrientation() == 0) {
            if (this.ltr) {
                return ((JSlider)this.component).getInverted();
            }
            return !((JSlider)this.component).getInverted();
        }
        return ((JSlider)this.component).getInverted();
    }

    protected Integer getHighestValue() {
        Dictionary dictionary = ((JSlider)this.component).getLabelTable();
        if (dictionary == null) {
            return null;
        }
        Enumeration keys = dictionary.keys();
        Integer max = null;
        while (keys.hasMoreElements()) {
            Integer i = (Integer)keys.nextElement();
            if (max != null && i <= max) continue;
            max = i;
        }
        return max;
    }

    protected Integer getLowestValue() {
        Dictionary dictionary = ((JSlider)this.component).getLabelTable();
        if (dictionary == null) {
            return null;
        }
        Enumeration keys = dictionary.keys();
        Integer min = null;
        while (keys.hasMoreElements()) {
            Integer i = (Integer)keys.nextElement();
            if (min != null && i >= min) continue;
            min = i;
        }
        return min;
    }

    protected Component getLowestValueLabel() {
        Integer min = this.getLowestValue();
        if (min != null) {
            return (Component)((JSlider)this.component).getLabelTable().get(min);
        }
        return null;
    }

    protected Component getHighestValueLabel() {
        Integer max = this.getHighestValue();
        if (max != null) {
            return (Component)((JSlider)this.component).getLabelTable().get(max);
        }
        return null;
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = ((JSlider)this.component).getLabelTable();
        int widest = 0;
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Component label = (Component)dictionary.get(keys.nextElement());
                widest = Math.max(label.getPreferredSize().width, widest);
            }
        }
        return widest;
    }

    protected int getHeightOfTallestLabel() {
        Dictionary dictionary = ((JSlider)this.component).getLabelTable();
        int tallest = 0;
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Component label = (Component)dictionary.get(keys.nextElement());
                tallest = Math.max(label.getPreferredSize().height, tallest);
            }
        }
        return tallest;
    }

    protected Dimension getThumbSize() {
        if (((JSlider)this.component).getOrientation() == 0) {
            return new Dimension(this.thumbWidth, this.thumbHeight);
        }
        return new Dimension(this.thumbHeight, this.thumbWidth);
    }

    public void paintThumb(Graphics2D g2d) {
        if (this.drawThumb) {
            Object aa = GraphicsUtils.setupAntialias(g2d);
            Shape ts = this.getThumbShape();
            if (((JSlider)this.component).getOrientation() == 0) {
                g2d.setPaint(new GradientPaint(0.0f, this.thumbRect.y, this.thumbBgTop, 0.0f, this.thumbRect.y + this.thumbRect.height, this.thumbBgBottom));
            } else {
                g2d.setPaint(new GradientPaint(this.thumbRect.x, 0.0f, this.thumbBgTop, this.thumbRect.x + this.thumbRect.width, 0.0f, this.thumbBgBottom));
            }
            g2d.fill(ts);
            g2d.setPaint(((JSlider)this.component).isEnabled() ? Color.GRAY : Color.LIGHT_GRAY);
            g2d.draw(ts);
            GraphicsUtils.restoreAntialias(g2d, aa);
        }
    }

    protected Shape getThumbShape() {
        if (this.angledThumb && (((JSlider)this.component).getPaintLabels() || ((JSlider)this.component).getPaintTicks())) {
            if (((JSlider)this.component).getOrientation() == 0) {
                GeneralPath gp = new GeneralPath(0);
                gp.moveTo(this.thumbRect.x, this.thumbRect.y + this.thumbRound);
                gp.quadTo(this.thumbRect.x, this.thumbRect.y, this.thumbRect.x + this.thumbRound, this.thumbRect.y);
                gp.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y);
                gp.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRound);
                gp.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                if (this.sharpThumbAngle) {
                    gp.lineTo(this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height);
                    gp.lineTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                } else {
                    gp.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength / 2, this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height);
                    gp.quadTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength / 2, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                }
                gp.closePath();
                return gp;
            }
            GeneralPath gp = new GeneralPath(0);
            if (this.ltr) {
                gp.moveTo(this.thumbRect.x, this.thumbRect.y + this.thumbRound);
                gp.quadTo(this.thumbRect.x, this.thumbRect.y, this.thumbRect.x + this.thumbRound, this.thumbRect.y);
                gp.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y);
                if (this.sharpThumbAngle) {
                    gp.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height / 2);
                    gp.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                } else {
                    gp.quadTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength / 2, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height / 2);
                    gp.quadTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength / 2, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                }
                gp.lineTo(this.thumbRect.x + this.thumbRound, this.thumbRect.y + this.thumbRect.height);
                gp.quadTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbRound);
            } else {
                gp.moveTo(this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y);
                gp.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRound);
                gp.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbRound);
                gp.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y + this.thumbRect.height);
                gp.lineTo(this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                if (this.sharpThumbAngle) {
                    gp.lineTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height / 2);
                    gp.lineTo(this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y);
                } else {
                    gp.quadTo(this.thumbRect.x + this.thumbAngleLength / 2, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height / 2);
                    gp.quadTo(this.thumbRect.x + this.thumbAngleLength / 2, this.thumbRect.y, this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y);
                }
            }
            gp.closePath();
            return gp;
        }
        return new RoundRectangle2D.Double(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, this.thumbRound * 2, this.thumbRound * 2);
    }

    public void paintTrack(Graphics2D g2d) {
        Object aa = GraphicsUtils.setupAntialias(g2d);
        Shape ss = this.getTrackShape();
        if (((JSlider)this.component).isEnabled()) {
            GraphicsUtils.drawShade(g2d, ss, ((JSlider)this.component).isFocusOwner() ? new Color(85, 142, 239) : new Color(210, 210, 210), this.trackShadeWidth);
        }
        if (((JSlider)this.component).getOrientation() == 0) {
            g2d.setPaint(new GradientPaint(0.0f, this.trackRect.y, this.trackBgTop, 0.0f, this.trackRect.y + this.trackRect.height, this.trackBgBottom));
        } else {
            g2d.setPaint(new GradientPaint(this.trackRect.x, 0.0f, this.trackBgTop, this.trackRect.x + this.trackRect.width, 0.0f, this.trackBgBottom));
        }
        g2d.fill(ss);
        if (this.drawProgress) {
            Shape ps = this.getProgressShape();
            if (((JSlider)this.component).isEnabled()) {
                GraphicsUtils.drawShade(g2d, ps, new Color(210, 210, 210), this.progressShadeWidth);
            }
            Rectangle bounds = ss.getBounds();
            if (((JSlider)this.component).getOrientation() == 0) {
                g2d.setPaint(new GradientPaint(0.0f, bounds.y + this.progressShadeWidth, this.progressTrackBgTop, 0.0f, bounds.y + bounds.height - this.progressShadeWidth, this.progressTrackBgBottom));
            } else {
                g2d.setPaint(new GradientPaint(bounds.x + this.progressShadeWidth, 0.0f, this.progressTrackBgTop, bounds.x + bounds.width - this.progressShadeWidth, 0.0f, this.progressTrackBgBottom));
            }
            g2d.fill(ps);
            g2d.setPaint(((JSlider)this.component).isEnabled() ? this.progressBorderColor : Color.LIGHT_GRAY);
            g2d.draw(ps);
        }
        g2d.setPaint(((JSlider)this.component).isEnabled() ? (this.rolloverDarkBorderOnly && !this.paintParameters.dragging ? this.getBorderColor() : Color.GRAY) : Color.LIGHT_GRAY);
        g2d.draw(ss);
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    protected Shape getTrackShape() {
        if (this.trackRound > 0) {
            if (((JSlider)this.component).getOrientation() == 0) {
                return new RoundRectangle2D.Double(this.trackRect.x - this.trackRound, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2, this.trackRect.width + this.trackRound * 2 - 1, this.trackHeight, this.trackRound * 2, this.trackRound * 2);
            }
            return new RoundRectangle2D.Double(this.trackRect.x + this.trackRect.width / 2 - this.trackHeight / 2, this.trackRect.y - this.trackRound, this.trackHeight, this.trackRect.height + this.trackRound * 2 - 1, this.trackRound * 2, this.trackRound * 2);
        }
        if (((JSlider)this.component).getOrientation() == 0) {
            return new Rectangle2D.Double(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2, this.trackRect.width - 1, this.trackHeight);
        }
        return new Rectangle2D.Double(this.trackRect.x + this.trackRect.width / 2 - this.trackHeight / 2, this.trackRect.y, this.trackHeight, this.trackRect.height - 1);
    }

    protected Shape getProgressShape() {
        if (this.trackRound > 0) {
            if (((JSlider)this.component).getOrientation() == 0) {
                int w;
                int x;
                if (this.ltr) {
                    x = this.trackRect.x - this.trackRound + this.progressShadeWidth;
                    w = this.thumbRect.x + this.thumbRect.width / 2 + this.progressRound - x;
                } else {
                    x = this.thumbRect.x + this.thumbRect.width / 2 - this.progressRound;
                    w = this.trackRect.x + this.trackRect.width + this.trackRound - this.progressShadeWidth - 1 - x;
                }
                return new RoundRectangle2D.Double(x, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2 + this.progressShadeWidth, w, this.trackHeight - this.progressShadeWidth * 2, this.progressRound * 2, this.progressRound * 2);
            }
            int y = this.thumbRect.y + this.thumbRect.height / 2;
            int h = this.trackRect.y + this.trackRect.height + this.trackRound - this.progressShadeWidth - y - 1;
            return new RoundRectangle2D.Double(this.trackRect.x + this.progressShadeWidth + this.trackRect.width / 2 - this.trackHeight / 2, y, this.trackHeight - this.progressShadeWidth * 2, h, this.progressRound * 2, this.progressRound * 2);
        }
        if (((JSlider)this.component).getOrientation() == 0) {
            int w;
            int x;
            if (this.ltr) {
                x = this.trackRect.x + this.progressShadeWidth;
                w = this.thumbRect.x + this.thumbRect.width / 2 - x;
            } else {
                x = this.thumbRect.x + this.thumbRect.width / 2;
                w = this.trackRect.x + this.trackRect.width - this.progressShadeWidth - 1 - x;
            }
            return new Rectangle2D.Double(x, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2 + this.progressShadeWidth, w, this.trackHeight - this.progressShadeWidth * 2);
        }
        int y = this.trackRect.y + this.progressShadeWidth;
        int h = this.thumbRect.y + this.thumbRect.height / 2 - y;
        return new Rectangle2D.Double(this.trackRect.x + this.progressShadeWidth + this.trackRect.width / 2 - this.trackHeight / 2, y, this.trackHeight - this.progressShadeWidth * 2, h);
    }

    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        g.setColor(((JSlider)this.component).isEnabled() ? Color.BLACK : Color.LIGHT_GRAY);
        if (((JSlider)this.component).getOrientation() == 0) {
            int xPos;
            int value;
            g.translate(0, tickBounds.y);
            if (((JSlider)this.component).getMinorTickSpacing() > 0) {
                for (value = ((JSlider)this.component).getMinimum(); value <= ((JSlider)this.component).getMaximum(); value += ((JSlider)this.component).getMinorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizontalSlider(g, tickBounds, xPos);
                }
            }
            if (((JSlider)this.component).getMajorTickSpacing() > 0) {
                for (value = ((JSlider)this.component).getMinimum(); value <= ((JSlider)this.component).getMaximum(); value += ((JSlider)this.component).getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizontalSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            int yPos;
            g.translate(tickBounds.x, 0);
            int value = ((JSlider)this.component).getMinimum();
            if (((JSlider)this.component).getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!this.ltr) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value <= ((JSlider)this.component).getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVerticalSlider(g, tickBounds, yPos);
                    value += ((JSlider)this.component).getMinorTickSpacing();
                }
                if (!this.ltr) {
                    g.translate(-offset, 0);
                }
            }
            if (((JSlider)this.component).getMajorTickSpacing() > 0) {
                value = ((JSlider)this.component).getMinimum();
                if (!this.ltr) {
                    g.translate(2, 0);
                }
                while (value <= ((JSlider)this.component).getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVerticalSlider(g, tickBounds, yPos);
                    value += ((JSlider)this.component).getMajorTickSpacing();
                }
                if (!this.ltr) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    protected void paintMinorTickForHorizontalSlider(Graphics g, Rectangle tickBounds, int x) {
        g.drawLine(x, 0, x, tickBounds.height / 2 - 1);
    }

    protected void paintMajorTickForHorizontalSlider(Graphics g, Rectangle tickBounds, int x) {
        g.drawLine(x, 0, x, tickBounds.height - 2);
    }

    protected void paintMinorTickForVerticalSlider(Graphics g, Rectangle tickBounds, int y) {
        g.drawLine(0, y, tickBounds.width / 2 - 1, y);
    }

    protected void paintMajorTickForVerticalSlider(Graphics g, Rectangle tickBounds, int y) {
        g.drawLine(0, y, tickBounds.width - 2, y);
    }

    public void paintLabels(Graphics g) {
        Rectangle labelBounds = this.labelRect;
        Dictionary dictionary = ((JSlider)this.component).getLabelTable();
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            int minValue = ((JSlider)this.component).getMinimum();
            int maxValue = ((JSlider)this.component).getMaximum();
            boolean enabled = ((JSlider)this.component).isEnabled();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                int value = key;
                if (value < minValue || value > maxValue) continue;
                Component label = (Component)dictionary.get(key);
                if (label instanceof JComponent) {
                    label.setEnabled(enabled);
                }
                if (((JSlider)this.component).getOrientation() == 0) {
                    g.translate(0, labelBounds.y);
                    this.paintHorizontalLabel(g, value, label);
                    g.translate(0, -labelBounds.y);
                    continue;
                }
                int offset = 0;
                if (!this.ltr) {
                    offset = labelBounds.width - label.getPreferredSize().width;
                }
                g.translate(labelBounds.x + offset, 0);
                this.paintVerticalLabel(g, value, label);
                g.translate(-labelBounds.x - offset, 0);
            }
        }
    }

    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        int labelCenter = this.xPositionForValue(value);
        int labelLeft = labelCenter - label.getPreferredSize().width / 2;
        g.translate(labelLeft, 0);
        label.paint(g);
        g.translate(-labelLeft, 0);
    }

    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        int labelCenter = this.yPositionForValue(value);
        int labelTop = labelCenter - label.getPreferredSize().height / 2;
        g.translate(0, labelTop);
        label.paint(g);
        g.translate(0, -labelTop);
    }

    protected float getProgress() {
        return (float)this.rolloverDarkness / 5.0f;
    }

    protected Color getBorderColor() {
        return ColorUtils.intermediate(new Color(170, 170, 170), Color.GRAY, this.getProgress());
    }
}

