/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.slider;

import com.alee.api.jdk.Objects;
import com.alee.laf.label.WebLabel;
import com.alee.managers.style.StyleId;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.UIResource;

public class SliderLabels
extends Hashtable
implements PropertyChangeListener {
    protected final JSlider slider;
    private final Integer start;
    private final Integer distance;

    public SliderLabels(JSlider slider) {
        this(slider, slider.getMinimum(), slider.getMajorTickSpacing());
    }

    public SliderLabels(JSlider slider, int start2, int distance) {
        this.slider = slider;
        this.start = start2 != slider.getMinimum() ? Integer.valueOf(start2) : null;
        this.distance = distance != slider.getMajorTickSpacing() ? Integer.valueOf(distance) : null;
        this.createLabels();
    }

    protected int getStart() {
        return this.start != null ? this.start.intValue() : this.slider.getMinimum();
    }

    protected int getDistance() {
        return this.distance != null ? this.distance.intValue() : this.slider.getMajorTickSpacing();
    }

    protected int getEnd() {
        return this.slider.getMaximum();
    }

    protected Object[] getProperties() {
        ArrayList<String> properties = new ArrayList<String>(3);
        properties.add("minimum");
        properties.add("maximum");
        if (this.distance == null) {
            properties.add("minorTickSpacing");
            properties.add("majorTickSpacing");
        }
        return properties.toArray();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (Objects.equals((Object)e.getPropertyName(), this.getProperties())) {
            Enumeration previousKeys = this.slider.getLabelTable().keys();
            Hashtable hashtable = new Hashtable();
            while (previousKeys.hasMoreElements()) {
                Object key = previousKeys.nextElement();
                Object value = this.slider.getLabelTable().get(key);
                if (value instanceof SliderLabel) continue;
                hashtable.put(key, value);
            }
            this.clear();
            this.createLabels();
            Enumeration keys = hashtable.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                this.put(key, hashtable.get(key));
            }
            this.slider.setLabelTable(this);
        }
    }

    protected void createLabels() {
        int distance = this.getDistance();
        if (distance > 0) {
            for (int value = this.getStart(); value <= this.getEnd(); value += distance) {
                this.put(value, this.createLabel(value));
            }
        }
    }

    protected JComponent createLabel(int value) {
        return new SliderLabel(Integer.toString(value));
    }

    protected class SliderLabel
    extends WebLabel
    implements UIResource {
        public SliderLabel(String text) {
            super(StyleId.sliderTickLabel.at(SliderLabels.this.slider), text);
            this.setName("Slider.label");
        }

        @Override
        public Font getFont() {
            Font current = super.getFont();
            Font font = current != null && !(current instanceof UIResource) ? current : SliderLabels.this.slider.getFont();
            return font;
        }
    }
}

