/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.api.annotations.NotNull;
import com.alee.laf.scroll.WebScrollBar;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.UIResource;

public class WebScrollPaneBar
extends WebScrollBar
implements UIResource {
    @NotNull
    private final transient WeakReference<JScrollPane> scrollPane;
    private boolean unitIncrementSet;
    private boolean blockIncrementSet;

    public WebScrollPaneBar(@NotNull JScrollPane scrollPane, int orientation) {
        super(orientation);
        this.scrollPane = new WeakReference<JScrollPane>(scrollPane);
        this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
    }

    @NotNull
    protected JScrollPane getScrollPane() {
        JScrollPane scrollPane = (JScrollPane)this.scrollPane.get();
        if (scrollPane == null) {
            throw new RuntimeException("JScrollPane is not available anymore");
        }
        return scrollPane;
    }

    @Override
    public void setUnitIncrement(int unitIncrement) {
        this.unitIncrementSet = true;
        this.putClientProperty("JScrollBar.fastWheelScrolling", null);
        super.setUnitIncrement(unitIncrement);
    }

    @Override
    public int getUnitIncrement(int direction) {
        int unitIncrement;
        JViewport vp = this.getScrollPane().getViewport();
        if (!this.unitIncrementSet && vp != null && vp.getView() instanceof Scrollable) {
            Scrollable view = (Scrollable)((Object)vp.getView());
            Rectangle vr = vp.getViewRect();
            unitIncrement = view.getScrollableUnitIncrement(vr, this.getOrientation(), direction);
        } else {
            unitIncrement = super.getUnitIncrement(direction);
        }
        return unitIncrement;
    }

    @Override
    public void setBlockIncrement(int blockIncrement) {
        this.blockIncrementSet = true;
        this.putClientProperty("JScrollBar.fastWheelScrolling", null);
        super.setBlockIncrement(blockIncrement);
    }

    @Override
    public int getBlockIncrement(int direction) {
        int blockIncrement;
        JViewport vp = this.getScrollPane().getViewport();
        if (this.blockIncrementSet || vp == null) {
            blockIncrement = super.getBlockIncrement(direction);
        } else if (vp.getView() instanceof Scrollable) {
            Scrollable view = (Scrollable)((Object)vp.getView());
            Rectangle vr = vp.getViewRect();
            blockIncrement = view.getScrollableBlockIncrement(vr, this.getOrientation(), direction);
        } else {
            blockIncrement = this.getOrientation() == 1 ? vp.getExtentSize().height : vp.getExtentSize().width;
        }
        return blockIncrement;
    }
}

