/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.scroll.ScrollPaneState;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ScrollPaneSettingsProcessor
extends SettingsProcessor<JScrollPane, ScrollPaneState, Configuration<ScrollPaneState>> {
    protected transient AdjustmentListener adjustmentListener;
    protected transient PropertyChangeListener propertyChangeListener;

    public ScrollPaneSettingsProcessor(JScrollPane scrollPane, Configuration configuration) {
        super(scrollPane, configuration);
    }

    @Override
    protected void register(@NotNull JScrollPane scrollPane) {
        this.adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ScrollPaneSettingsProcessor.this.save();
            }
        };
        scrollPane.getHorizontalScrollBar().addAdjustmentListener(this.adjustmentListener);
        scrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JScrollBar newScrollBar;
                JScrollBar oldScrollBar = (JScrollBar)evt.getOldValue();
                if (oldScrollBar != null) {
                    oldScrollBar.removeAdjustmentListener(ScrollPaneSettingsProcessor.this.adjustmentListener);
                }
                if ((newScrollBar = (JScrollBar)evt.getNewValue()) != null) {
                    newScrollBar.addAdjustmentListener(ScrollPaneSettingsProcessor.this.adjustmentListener);
                }
            }
        };
        scrollPane.addPropertyChangeListener("horizontalScrollBar", this.propertyChangeListener);
        scrollPane.addPropertyChangeListener("verticalScrollBar", this.propertyChangeListener);
    }

    @Override
    protected void unregister(@NotNull JScrollPane scrollPane) {
        scrollPane.removePropertyChangeListener("verticalScrollBar", this.propertyChangeListener);
        scrollPane.removePropertyChangeListener("horizontalScrollBar", this.propertyChangeListener);
        this.propertyChangeListener = null;
        scrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        scrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        this.adjustmentListener = null;
    }

    @Override
    @Nullable
    protected ScrollPaneState createDefaultValue() {
        return new ScrollPaneState((JScrollPane)this.component());
    }

    @Override
    protected void loadSettings(@NotNull JScrollPane scrollPane) {
        ((ScrollPaneState)this.loadSettings()).apply(scrollPane);
    }

    @Override
    protected void saveSettings(@NotNull JScrollPane scrollPane) {
        this.saveSettings(new ScrollPaneState(scrollPane));
    }
}

