/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.scroll.ScrollBarState;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;

public class ScrollBarSettingsProcessor
extends SettingsProcessor<JScrollBar, ScrollBarState, Configuration<ScrollBarState>> {
    protected transient AdjustmentListener adjustmentListener;

    public ScrollBarSettingsProcessor(JScrollBar scrollBar, Configuration configuration) {
        super(scrollBar, configuration);
    }

    @Override
    protected void register(@NotNull JScrollBar scrollBar) {
        this.adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ScrollBarSettingsProcessor.this.save();
            }
        };
        scrollBar.addAdjustmentListener(this.adjustmentListener);
    }

    @Override
    protected void unregister(@NotNull JScrollBar scrollBar) {
        scrollBar.removeAdjustmentListener(this.adjustmentListener);
        this.adjustmentListener = null;
    }

    @Override
    @Nullable
    protected ScrollBarState createDefaultValue() {
        return new ScrollBarState((JScrollBar)this.component());
    }

    @Override
    protected void loadSettings(@NotNull JScrollBar scrollBar) {
        ((ScrollBarState)this.loadSettings()).apply(scrollBar);
    }

    @Override
    protected void saveSettings(@NotNull JScrollBar scrollBar) {
        this.saveSettings(new ScrollBarState(scrollBar));
    }
}

