/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.api.data.CompassDirection;
import com.alee.extended.behavior.ComponentMoveBehavior;
import com.alee.laf.rootpane.WRootPaneUI;
import com.alee.laf.window.WebDialog;
import com.alee.managers.animation.easing.Quadratic;
import com.alee.managers.animation.framerate.FixedFrameRate;
import com.alee.managers.animation.transition.AbstractTransition;
import com.alee.managers.animation.transition.TimedTransition;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.transition.TransitionAdapter;
import com.alee.managers.animation.transition.TransitionListener;
import com.alee.managers.style.StyleId;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;

public class WindowDecorationBehavior
extends ComponentMoveBehavior {
    protected final WRootPaneUI rootPaneUI;
    protected WebDialog glassDialog;
    protected Rectangle normalBounds;
    protected Rectangle stickBounds;
    protected CompassDirection stickDirection;
    protected final AbstractTransition<Float> fadeIn;

    public WindowDecorationBehavior(WRootPaneUI rootPaneUI) {
        super(rootPaneUI.getTitleComponent());
        this.rootPaneUI = rootPaneUI;
        this.fadeIn = new TimedTransition<Float>(Float.valueOf(0.0f), Float.valueOf(1.0f), new FixedFrameRate(30.0), new Quadratic.Out(), 200L);
        this.fadeIn.addListener((TransitionListener<Float>)new TransitionAdapter<Float>(){

            @Override
            public void started(Transition transition, Float value) {
                if (WindowDecorationBehavior.this.stickBounds != null) {
                    WindowDecorationBehavior.this.glassDialog.setBounds(WindowDecorationBehavior.this.stickBounds);
                    WindowDecorationBehavior.this.glassDialog.setWindowOpacity(value.floatValue());
                }
            }

            @Override
            public void adjusted(Transition transition, Float value) {
                if (WindowDecorationBehavior.this.stickBounds != null) {
                    WindowDecorationBehavior.this.glassDialog.setWindowOpacity(value.floatValue());
                }
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtils.isDoubleClick(e) && this.isMaximizable()) {
            if (this.rootPaneUI.isMaximized()) {
                this.rootPaneUI.restore();
            } else {
                this.rootPaneUI.maximize();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragging && this.rootPaneUI.isMaximized()) {
            this.rootPaneUI.restore();
        }
        super.mouseDragged(e);
    }

    @Override
    protected void componentMoveStarted(Point mouse, Point location) {
        if (this.isStickingAvailable()) {
            this.normalBounds = this.getWindow().getBounds();
        }
    }

    @Override
    protected void componentMoved(Point mouse, Point location) {
        if (this.isStickingAvailable()) {
            GraphicsDevice device = SystemUtils.getGraphicsDevice(mouse);
            Rectangle screenBounds = SystemUtils.getDeviceBounds(device, true);
            if (screenBounds.contains(mouse)) {
                int state;
                CompassDirection direction;
                if (mouse.y < screenBounds.y + 10) {
                    direction = CompassDirection.north;
                    state = 6;
                } else if (mouse.x < screenBounds.x + 10) {
                    direction = CompassDirection.west;
                    state = 4;
                } else if (mouse.x > screenBounds.x + screenBounds.width - 10) {
                    direction = CompassDirection.east;
                    state = 4;
                } else {
                    direction = null;
                    state = -1;
                }
                if (direction != null && SystemUtils.isFrameStateSupported(state)) {
                    this.displayGlassDialog(screenBounds, direction);
                } else {
                    this.disposeGlassDialog();
                }
            } else {
                this.disposeGlassDialog();
            }
        }
    }

    @Override
    protected void componentMoveEnded(Point mouse, Point location) {
        if (this.isStickingAvailable()) {
            if (this.stickDirection != null) {
                switch (this.stickDirection) {
                    case west: {
                        this.rootPaneUI.maximizeWest();
                        break;
                    }
                    case east: {
                        this.rootPaneUI.maximizeEast();
                        break;
                    }
                    default: {
                        this.rootPaneUI.maximize();
                        break;
                    }
                }
            } else {
                this.normalBounds = null;
            }
            this.disposeGlassDialog();
        }
    }

    protected void displayGlassDialog(Rectangle screen, CompassDirection direction) {
        if (direction != this.stickDirection) {
            this.disposeGlassDialog();
        }
        if (!this.isGlassDialogVisible()) {
            Window window = this.getWindow();
            if (this.glassDialog == null || window != this.glassDialog.getOwner()) {
                if (this.glassDialog != null) {
                    this.glassDialog.dispose();
                    this.glassDialog = null;
                }
                this.glassDialog = new WebDialog(StyleId.frameGlassDialog.at(window), window);
                this.glassDialog.setAlwaysOnTop(true);
                this.glassDialog.pack();
            }
            this.glassDialog.setBounds(0, 0, 100, 100);
            this.glassDialog.setWindowOpacity(0.0f);
            this.stickDirection = direction;
            this.stickBounds = direction == CompassDirection.west ? new Rectangle(screen.x, screen.y, screen.width / 2, screen.height) : (direction == CompassDirection.east ? new Rectangle(screen.x + screen.width - screen.width / 2, screen.y, screen.width / 2, screen.height) : screen);
            this.glassDialog.setVisible(true);
            this.fadeIn.play();
        }
    }

    protected void disposeGlassDialog() {
        if (this.isGlassDialogVisible()) {
            this.fadeIn.stop();
            this.stickDirection = null;
            this.stickBounds = null;
            this.glassDialog.setWindowOpacity(0.0f);
            this.glassDialog.setVisible(false);
        }
    }

    protected boolean isGlassDialogVisible() {
        return this.glassDialog != null && this.glassDialog.isShowing();
    }

    private Window getWindow() {
        return this.rootPaneUI.getWindow();
    }

    protected boolean isFrame() {
        return this.rootPaneUI.isFrame();
    }

    protected JFrame getFrame() {
        if (!this.isFrame()) {
            throw new RuntimeException("Incorrect window type requested");
        }
        return (JFrame)this.getWindow();
    }

    protected boolean isResizable() {
        return this.isFrame() && this.getFrame().isResizable();
    }

    protected boolean isMaximizable() {
        return this.isResizable() && this.rootPaneUI.isDisplayMaximizeButton();
    }

    protected boolean isStickingAvailable() {
        return SystemUtils.isWindows() && this.isMaximizable();
    }
}

