/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.progressbar;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.progressbar.WProgressBarUI;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class WebProgressBarUI<C extends JProgressBar>
extends WProgressBarUI<C> {
    protected transient EventsHandler eventsHandler;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebProgressBarUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.progressBar);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.progressBar);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.eventsHandler = new EventsHandler();
        this.progressBar.addChangeListener(this.eventsHandler);
        this.progressBar.addPropertyChangeListener(this.eventsHandler);
    }

    @Override
    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.eventsHandler);
        this.progressBar.removePropertyChangeListener(this.eventsHandler);
        this.eventsHandler = null;
        super.uninstallListeners();
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c);
    }

    protected class EventsHandler
    implements ChangeListener,
    PropertyChangeListener {
        protected EventsHandler() {
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            WebProgressBarUI.this.progressBar.repaint();
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (Objects.equals((Object)propertyName, (Object)"indeterminate")) {
                WebProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

