/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.menu.IPopupMenuPainter;
import com.alee.laf.menu.PopupMenuWay;
import com.alee.laf.menu.WPopupMenuUI;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;

public class WebPopupMenuUI
extends WPopupMenuUI
implements SwingConstants {
    protected transient PopupMenuWay popupMenuWay = null;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebPopupMenuUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        SwingUtils.setHandlesEnableStateMark(this.popupMenu);
        StyleManager.installSkin(this.popupMenu);
        if (StyleManager.getStyleId(this.popupMenu) == StyleId.popupmenu && this.popupMenu.getInvoker() instanceof JMenu) {
            StyleId.menuPopupMenu.at((JMenu)this.popupMenu.getInvoker()).set(this.popupMenu);
        }
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.popupMenu);
        SwingUtils.removeHandlesEnableStateMark(this.popupMenu);
        super.uninstallUI(c);
    }

    @Override
    public void setPopupMenuWay(PopupMenuWay way) {
        this.popupMenuWay = way;
    }

    @Override
    public PopupMenuWay getPopupMenuWay() {
        return this.popupMenuWay;
    }

    @Override
    @NotNull
    public Popup getPopup(@NotNull JPopupMenu popup, int x, int y) {
        Point fixed;
        Painter painter = PainterSupport.getPainter(popup);
        if (painter instanceof IPopupMenuPainter && (fixed = ((IPopupMenuPainter)painter).preparePopupMenu(popup, popup.getInvoker(), x, y)) != null) {
            x = fixed.x;
            y = fixed.y;
        }
        Popup p = super.getPopup(popup, x, y);
        if (painter instanceof IPopupMenuPainter) {
            ((IPopupMenuPainter)painter).configurePopup(popup, popup.getInvoker(), x, y, p);
        }
        return p;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return null;
    }
}

