/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.UIAction;
import com.alee.laf.UIActionMap;
import com.alee.laf.menu.MenuBarInputListener;
import com.alee.laf.menu.WMenuBarUI;
import com.alee.utils.LafLookup;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WMenuBarInputListener<C extends JMenuBar, U extends WMenuBarUI<C>>
extends AbstractUIInputListener<C, U>
implements MenuBarInputListener<C>,
ContainerListener,
ChangeListener {
    @Override
    public void install(@NotNull C component2) {
        super.install(component2);
        for (int i = 0; i < ((JMenuBar)component2).getMenuCount(); ++i) {
            JMenu menu = ((JMenuBar)component2).getMenu(i);
            if (menu == null) continue;
            menu.getModel().addChangeListener(this);
        }
        ((Container)component2).addContainerListener(this);
        UIActionMap actionMap = new UIActionMap();
        actionMap.put(new Action<C>(component2, "takeFocus"));
        SwingUtilities.replaceUIActionMap(component2, actionMap);
        InputMap inputMap = LafLookup.getInputMap(component2, 2);
        SwingUtilities.replaceUIInputMap(component2, 2, inputMap);
    }

    @Override
    public void uninstall(@NotNull C component2) {
        SwingUtilities.replaceUIInputMap(component2, 2, null);
        SwingUtilities.replaceUIActionMap(component2, null);
        ((Container)component2).removeContainerListener(this);
        for (int i = 0; i < ((JMenuBar)component2).getMenuCount(); ++i) {
            JMenu menu = ((JMenuBar)component2).getMenu(i);
            if (menu == null) continue;
            menu.getModel().removeChangeListener(this);
        }
        super.uninstall(component2);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component child = e.getChild();
        if (child instanceof JMenu) {
            ((JMenu)child).getModel().addChangeListener(this);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component child = e.getChild();
        if (child instanceof JMenu) {
            ((JMenu)child).getModel().removeChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int menuCount = ((JMenuBar)this.component).getMenuCount();
        for (int i = 0; i < menuCount; ++i) {
            JMenu menu = ((JMenuBar)this.component).getMenu(i);
            if (menu == null || !menu.isSelected()) continue;
            ((JMenuBar)this.component).getSelectionModel().setSelectedIndex(i);
            break;
        }
    }

    public static class Action<M extends JMenuBar>
    extends UIAction<M> {
        public static final String TAKE_FOCUS = "takeFocus";

        public Action(@NotNull M menuBar, @NotNull String name) {
            super(menuBar, name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenu menu;
            JMenuBar menuBar = (JMenuBar)e.getSource();
            String key = this.getName();
            if (Objects.equals((Object)key, (Object)TAKE_FOCUS) && (menu = menuBar.getMenu(0)) != null) {
                MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
                defaultManager.setSelectedPath(new MenuElement[]{menuBar, menu, menu.getPopupMenu()});
            }
        }
    }
}

