/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list.editor;

import com.alee.laf.list.editor.AbstractListCellEditor;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.StyleId;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JList;

public abstract class TextListCellEditor<T>
extends AbstractListCellEditor<WebTextField, T> {
    @Override
    protected WebTextField createCellEditor(final JList list, int index, T value) {
        String text = this.valueToText(list, index, value);
        final WebTextField editor = new WebTextField(StyleId.listTextCellEditor.at(list));
        editor.setText(text);
        editor.selectAll();
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TextListCellEditor.this.stopEdit(list);
            }
        };
        editor.addFocusListener(focusAdapter);
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.ENTER.isTriggered(e)) {
                    editor.removeFocusListener(focusAdapter);
                    TextListCellEditor.this.stopEdit(list);
                    list.requestFocusInWindow();
                } else if (Hotkey.ESCAPE.isTriggered(e)) {
                    editor.removeFocusListener(focusAdapter);
                    TextListCellEditor.this.cancelEdit(list);
                    list.requestFocusInWindow();
                }
            }
        });
        return editor;
    }

    @Override
    public T getCellEditorValue(JList list, int index, T oldValue) {
        String text = ((WebTextField)this.editor).getText();
        return this.textToValue(list, index, oldValue, text);
    }

    protected abstract String valueToText(JList var1, int var2, T var3);

    protected abstract T textToValue(JList var1, int var2, T var3, String var4);
}

