/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list.behavior;

import com.alee.extended.behavior.Behavior;
import com.alee.laf.list.WebList;
import java.awt.Rectangle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelectionScrollBehavior
implements ListSelectionListener,
Behavior {
    protected final WebList list;

    public ListSelectionScrollBehavior(WebList list) {
        this.list = list;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index;
        Rectangle selection2;
        if (this.list.getSelectedIndex() != -1 && (selection2 = this.list.getCellBounds(index = this.list.getLeadSelectionIndex(), index)) != null && !selection2.intersects(this.list.getVisibleRect())) {
            this.list.scrollRectToVisible(selection2);
        }
    }

    public static ListSelectionScrollBehavior install(WebList list) {
        ListSelectionScrollBehavior.uninstall(list);
        ListSelectionScrollBehavior behavior = new ListSelectionScrollBehavior(list);
        list.addListSelectionListener(behavior);
        return behavior;
    }

    public static void uninstall(WebList list) {
        for (ListSelectionListener listener : list.getListSelectionListeners()) {
            if (!(listener instanceof ListSelectionScrollBehavior)) continue;
            list.removeListSelectionListener(listener);
        }
    }

    public static boolean isInstalled(WebList list) {
        for (ListSelectionListener listener : list.getListSelectionListeners()) {
            if (!(listener instanceof ListSelectionScrollBehavior)) continue;
            return true;
        }
        return false;
    }
}

