/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.Behavior;
import com.alee.laf.list.WebList;
import com.alee.utils.swing.HoverListener;

public class ListHoverSelectionBehavior
implements HoverListener<Integer>,
Behavior {
    @NotNull
    protected final WebList list;

    public ListHoverSelectionBehavior(@NotNull WebList list) {
        this.list = list;
    }

    @Override
    public void hoverChanged(@Nullable Integer previous, @Nullable Integer current) {
        if (current != null && current != -1) {
            this.list.setSelectedIndex(current);
        } else {
            this.list.clearSelection();
        }
    }

    public static ListHoverSelectionBehavior install(@NotNull WebList list) {
        ListHoverSelectionBehavior.uninstall(list);
        ListHoverSelectionBehavior behavior = new ListHoverSelectionBehavior(list);
        list.addHoverListener(behavior);
        return behavior;
    }

    public static void uninstall(@NotNull WebList list) {
        for (HoverListener listener : list.getHoverListeners()) {
            if (!(listener instanceof ListHoverSelectionBehavior)) continue;
            list.removeHoverListener(listener);
        }
    }

    public static boolean isInstalled(@NotNull WebList list) {
        boolean installed = false;
        for (HoverListener listener : list.getHoverListeners()) {
            if (!(listener instanceof ListHoverSelectionBehavior)) continue;
            installed = true;
            break;
        }
        return installed;
    }
}

