/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.list.IListPainter;
import com.alee.laf.list.ListCellArea;
import com.alee.laf.list.ListPaintParameters;
import com.alee.laf.list.ListSelectionStyle;
import com.alee.laf.list.ListToolTipProvider;
import com.alee.laf.list.WListUI;
import com.alee.laf.list.WebList;
import com.alee.laf.list.behavior.ListItemHoverBehavior;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.UIException;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.ReflectUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.plaf.ComponentUI;

public class WebListUI
extends WListUI {
    public static final int heightChanged = 256;
    public static final int widthChanged = 512;
    protected ListSelectionStyle selectionStyle;
    protected transient ListItemHoverBehavior hoverCellTracker;
    protected transient int hoverIndex = -1;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebListUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        this.hoverCellTracker = new ListItemHoverBehavior<JList>(this.list, true){

            @Override
            public void hoverChanged(@NotNull Integer previous, @NotNull Integer current) {
                ListToolTipProvider provider;
                int previousIndex = WebListUI.this.hoverIndex;
                WebListUI.this.hoverIndex = current;
                Painter painter = PainterSupport.getPainter(WebListUI.this.list);
                if (painter instanceof IListPainter && ((IListPainter)painter).isItemHoverDecorationSupported()) {
                    this.repaintCell(previousIndex);
                    this.repaintCell(WebListUI.this.hoverIndex);
                }
                if ((provider = WebListUI.this.getToolTipProvider()) != null) {
                    provider.hoverAreaChanged(WebListUI.this.list, previousIndex != -1 ? new ListCellArea(previousIndex) : null, WebListUI.this.hoverIndex != -1 ? new ListCellArea(WebListUI.this.hoverIndex) : null);
                }
                if (WebListUI.this.list instanceof WebList) {
                    ((WebList)WebListUI.this.list).fireHoverChanged(previous, current);
                }
            }

            private void repaintCell(int index) {
                Rectangle cellBounds;
                if (index != -1 && (cellBounds = WebListUI.this.list.getCellBounds(index, index)) != null) {
                    WebListUI.this.list.repaint(cellBounds);
                }
            }
        };
        this.hoverCellTracker.install();
        StyleManager.installSkin(this.list);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.list);
        this.hoverCellTracker.uninstall();
        this.hoverCellTracker = null;
        super.uninstallUI(c);
    }

    @Override
    public int getHoverIndex() {
        return this.hoverIndex;
    }

    @Override
    public ListSelectionStyle getSelectionStyle() {
        return this.selectionStyle;
    }

    @Override
    public void setSelectionStyle(ListSelectionStyle style) {
        this.selectionStyle = style;
    }

    @Override
    public void updateListLayout() {
        this.updateLayoutStateNeeded = 1;
        this.redrawList();
    }

    @Override
    public CellRendererPane getCellRendererPane() {
        return this.rendererPane;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        this.validateListLayout();
        PainterSupport.paint(g, c, this, new ListPaintParameters(this.getListWidth(), this.getListHeight(), this.getColumnCount(), this.getRowsPerColumn(), this.getPreferredHeight(), this.cellWidth, this.cellHeight, this.cellHeights));
    }

    protected void validateListLayout() {
        switch (this.list.getLayoutOrientation()) {
            case 1: {
                if (this.list.getHeight() == this.getListHeight()) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.getListWidth()) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
    }

    public void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected int getListHeight() {
        Integer listHeight = (Integer)this.getBasicListUIValue("listHeight");
        if (listHeight == null) {
            throw new UIException("List height value is not available");
        }
        return listHeight;
    }

    protected int getListWidth() {
        Integer listWidth = (Integer)this.getBasicListUIValue("listWidth");
        if (listWidth == null) {
            throw new UIException("List width value is not available");
        }
        return listWidth;
    }

    protected int getColumnCount() {
        Integer columnCount = (Integer)this.getBasicListUIValue("columnCount");
        if (columnCount == null) {
            throw new UIException("List column count value is not available");
        }
        return columnCount;
    }

    protected int getRowsPerColumn() {
        Integer rowsPerColumn = (Integer)this.getBasicListUIValue("rowsPerColumn");
        if (rowsPerColumn == null) {
            throw new UIException("List rows per column value is not available");
        }
        return rowsPerColumn;
    }

    protected int getPreferredHeight() {
        Integer preferredHeight = (Integer)this.getBasicListUIValue("preferredHeight");
        if (preferredHeight == null) {
            throw new UIException("List preferred height value is not available");
        }
        return preferredHeight;
    }

    @Nullable
    protected <T> T getBasicListUIValue(@NotNull String field2) {
        try {
            return ReflectUtils.getFieldValue(this, field2);
        }
        catch (Exception e) {
            throw new UIException("Unable to access BasicListUI field: " + field2, e);
        }
    }

    @Nullable
    protected ListToolTipProvider getToolTipProvider() {
        return this.list != null ? (ListToolTipProvider)this.list.getClientProperty("tooltipProvider") : null;
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c));
    }
}

