/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.utils.CollectionUtils;
import com.alee.utils.compare.IntegerComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class WebListModel<T>
extends AbstractListModel {
    protected Vector<T> delegate = new Vector();

    public WebListModel() {
        this(Collections.emptyList());
    }

    public WebListModel(T ... data) {
        this((Collection<T>)CollectionUtils.asList(data));
    }

    public WebListModel(Collection<T> data) {
        this.addAll(data);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.get(index);
    }

    public List<T> getElements() {
        return new ArrayList<T>(this.delegate);
    }

    public void copyInto(T[] array) {
        this.delegate.copyInto(array);
    }

    public void trimToSize() {
        this.delegate.trimToSize();
    }

    public void ensureCapacity(int capacity) {
        this.delegate.ensureCapacity(capacity);
    }

    public int capacity() {
        return this.delegate.capacity();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Enumeration<T> elements() {
        return this.delegate.elements();
    }

    public boolean contains(T element) {
        return this.delegate.contains(element);
    }

    public int indexOf(T element) {
        return this.delegate.indexOf(element);
    }

    public int indexOf(T element, int index) {
        return this.delegate.indexOf(element, index);
    }

    public int lastIndexOf(T element) {
        return this.delegate.lastIndexOf(element);
    }

    public int lastIndexOf(T element, int index) {
        return this.delegate.lastIndexOf(element, index);
    }

    public T first() {
        return this.delegate.firstElement();
    }

    public T last() {
        return this.delegate.lastElement();
    }

    public Object[] toArray() {
        Object[] rv = new Object[this.delegate.size()];
        this.delegate.copyInto(rv);
        return rv;
    }

    public T get(int index) {
        return this.delegate.elementAt(index);
    }

    public void add(T element) {
        this.add(this.getSize(), element);
    }

    public void add(int index, T element) {
        this.addAll(index, element);
    }

    public void addAll(T ... elements) {
        this.addAll((Collection<T>)CollectionUtils.asList(elements));
    }

    public void addAll(Collection<T> elements) {
        this.addAll(this.delegate.size(), elements);
    }

    public void addAll(int index, T ... elements) {
        this.addAll(index, (Collection<T>)CollectionUtils.asList(elements));
    }

    public void addAll(int index, Collection<T> elements) {
        if (elements.size() > 0) {
            this.delegate.addAll(index, elements);
            this.fireIntervalAdded(this, index, elements.size() - 1);
        }
    }

    public T set(int index, T element) {
        T rv = this.delegate.elementAt(index);
        this.delegate.setElementAt(element, index);
        this.fireContentsChanged(this, index, index);
        return rv;
    }

    public void setAll(T ... elements) {
        this.setAll((Collection<T>)CollectionUtils.asList(elements));
    }

    public void setAll(Collection<T> elements) {
        this.removeAll();
        this.addAll(elements);
    }

    public T remove(T element) {
        int index = this.indexOf(element);
        return index != -1 ? (T)this.remove(index) : null;
    }

    public T remove(int index) {
        T element = this.delegate.elementAt(index);
        this.removeInterval(index, index);
        return element;
    }

    public void removeAllBefore(int index) {
        if (index <= 0) {
            throw new IllegalArgumentException("There are no elements below zero index");
        }
        this.removeInterval(0, index - 1);
    }

    public void removeAllAfter(int index) {
        if (index >= this.delegate.size() - 1) {
            throw new IllegalArgumentException("There are no elements after " + index + " index");
        }
        this.removeInterval(index + 1, this.delegate.size() - 1);
    }

    public void removeAll(T ... elements) {
        this.removeAll((Collection<T>)CollectionUtils.asList(elements));
    }

    public void removeAll(Collection<T> elements) {
        ArrayList<Integer> indices = new ArrayList<Integer>(elements.size());
        for (T element : elements) {
            int index = this.delegate.indexOf(element);
            if (index == -1) continue;
            indices.add(index);
        }
        CollectionUtils.distinct(indices);
        CollectionUtils.sort(indices, IntegerComparator.instance());
        int rangeStart = -1;
        int rangeEnd = -1;
        for (int i = indices.size() - 1; i >= 0; --i) {
            int index = (Integer)indices.get(i);
            if (rangeStart == -1 || rangeEnd == -1) {
                rangeStart = index;
                rangeEnd = index;
            } else if (index == rangeStart - 1) {
                rangeStart = index;
            } else {
                rangeStart = index;
                rangeEnd = index;
            }
            if (i != 0 && rangeStart - 1 == (Integer)indices.get(i - 1)) continue;
            this.removeInterval(rangeStart, rangeEnd);
        }
    }

    public void removeAll() {
        if (this.delegate.size() > 0) {
            this.removeInterval(0, this.delegate.size() - 1);
        }
    }

    public void removeInterval(int start2, int end) {
        if (start2 > end) {
            throw new IllegalArgumentException("Interval end index cannot be less than start index");
        }
        for (int i = end; i >= start2; --i) {
            this.delegate.removeElementAt(i);
        }
        this.fireIntervalRemoved(this, start2, end);
    }

    public void update(T element) {
        int index = this.indexOf(element);
        if (index != -1) {
            this.fireContentsChanged(this, index, index);
        }
    }

    @Override
    public void fireContentsChanged(Object source, int index0, int index1) {
        super.fireContentsChanged(source, index0, index1);
    }

    @Override
    public void fireIntervalAdded(Object source, int index0, int index1) {
        super.fireIntervalAdded(source, index0, index1);
    }

    @Override
    public void fireIntervalRemoved(Object source, int index0, int index1) {
        super.fireIntervalRemoved(source, index0, index1);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

