/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.tooltip.AbstractComponentArea;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ListCellArea<V, C extends JList>
extends AbstractComponentArea<V, C> {
    protected final int index;

    public ListCellArea(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    @Override
    public boolean isAvailable(@NotNull C component2) {
        return 0 <= this.index && this.index < ((JList)component2).getModel().getSize();
    }

    @Override
    @Nullable
    public Rectangle getBounds(@NotNull C component2) {
        Rectangle bounds = ((JList)component2).getCellBounds(this.index, this.index);
        V value = this.getValue(component2);
        boolean isSelected = ((JList)component2).isSelectedIndex(this.index);
        boolean cellHasFocus = ((JList)component2).getLeadSelectionIndex() == this.index;
        ListCellRenderer<V> cellRenderer = ((JList)component2).getCellRenderer();
        Component renderer = cellRenderer.getListCellRendererComponent((JList<V>)component2, value, this.index, isSelected, cellHasFocus);
        this.adjustBounds(component2, renderer, bounds);
        return bounds;
    }

    @Override
    @Nullable
    public V getValue(@NotNull C component2) {
        return (V)((JList)component2).getModel().getElementAt(this.index);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ListCellArea && this.index == ((ListCellArea)other).index;
    }
}

