/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.information;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.api.version.Version;
import com.alee.extended.behavior.ComponentMoveBehavior;
import com.alee.extended.image.WebImage;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.link.AbstractLinkAction;
import com.alee.extended.link.LinkAction;
import com.alee.extended.link.UrlLinkAction;
import com.alee.extended.link.WebLink;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.information.AboutLibraryExtension;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.table.WebTable;
import com.alee.laf.text.WebTextArea;
import com.alee.laf.window.WebDialog;
import com.alee.laf.window.WebFrame;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.icon.LazyIcon;
import com.alee.managers.language.LM;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.jar.JarEntry;
import com.alee.utils.jar.JarStructure;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import org.slf4j.LoggerFactory;

public class AboutLibraryDialog
extends WebFrame {
    @NotNull
    private static final String LIBRARY_DATA_SEPARATOR = " - ";

    private AboutLibraryDialog() {
        super("weblaf.about.dialog.title");
        this.setIconImages(WebLookAndFeel.getImages());
        ComponentMoveBehavior moveBehavior = new ComponentMoveBehavior(this);
        moveBehavior.install();
        WebDocumentPane<DocumentData<Component>> documentPane = new WebDocumentPane<DocumentData<Component>>(StyleId.of("tabs"));
        documentPane.setClosable(false);
        documentPane.setDragEnabled(false);
        documentPane.setTabMenuEnabled(false);
        documentPane.openDocument(new DocumentData<Component>("general", "weblaf.about.dialog.general.title", this.createGeneralTab()), true);
        documentPane.openDocument(new DocumentData<Component>("libraries", "weblaf.about.dialog.libraries.title", this.createLibrariesTab()), false);
        documentPane.openDocument(new DocumentData<Component>("properties", "weblaf.about.dialog.properties.title", this.createPropertiesTab()), false);
        this.add(documentPane);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @NotNull
    private Component createGeneralTab() {
        WebPanel content = new WebPanel(StyleId.of("general"), new VerticalFlowLayout(30, 30), new Component[0]);
        content.add((Component)this.createLibraryVersionPanel());
        content.add((Component)new WebSeparator(0));
        content.add((Component)this.createJavaVersionPanel());
        content.add((Component)new WebSeparator(0));
        content.add((Component)this.createOsVersionPanel());
        return content;
    }

    @NotNull
    private WebPanel createLibraryVersionPanel() {
        Version version = new Version(AboutLibraryDialog.class);
        WebImage icon = new WebImage(WebLookAndFeel.getIcon(32));
        WebLink versionNumber = new WebLink(version.toString(), (LinkAction)new UrlLinkAction("https://github.com/mgarin/weblaf"));
        versionNumber.setBoldFont();
        WebLabel versionName = new WebLabel(version.name());
        return new GroupPanel(StyleId.panelTransparent, 15, icon, new GroupPanel(false, versionNumber, versionName));
    }

    @NotNull
    private WebPanel createJavaVersionPanel() {
        WebImage javaIcon = new WebImage(new LazyIcon("java32"));
        WebLink javaVersion = new WebLink();
        javaVersion.setLanguage("weblaf.about.dialog.general.java.version", SystemUtils.getJavaVersionString());
        javaVersion.addAction(new UrlLinkAction("http://www.oracle.com/technetwork/java/javase/overview/"));
        javaVersion.setBoldFont();
        WebLabel javaName = new WebLabel(SystemUtils.getJavaName());
        return new GroupPanel(StyleId.panelTransparent, 15, javaIcon, new GroupPanel(false, javaVersion, javaName));
    }

    @NotNull
    private WebPanel createOsVersionPanel() {
        WebImage osIcon = new WebImage(SystemUtils.getOsIcon(32, false));
        WebLink version = new WebLink(SystemUtils.getOsName(), (LinkAction)new UrlLinkAction(SystemUtils.getOsSite()));
        version.setBoldFont();
        WebLabel osVersion = new WebLabel();
        osVersion.setLanguage("weblaf.about.dialog.general.os.arch", SystemUtils.getOsArch());
        return new GroupPanel(StyleId.panelTransparent, 15, osIcon, new GroupPanel(false, version, osVersion));
    }

    @NotNull
    private Component createLibrariesTab() {
        JComponent tab = null;
        try {
            JarStructure structure = new JarStructure(this.getClass());
            JarEntry licensesFolder = structure.getRoot().getChildByName("licenses");
            JarEntry librariesDataFile = licensesFolder.getChildByName("libraries.data");
            String librariesDataText = FileUtils.readToString(librariesDataFile.getInputStream());
            Map<String, String> librariesData = this.parseUrls(librariesDataText);
            WebPanel librariesPanel = new WebPanel(StyleId.of("libraries"), new VerticalFlowLayout(0, 5), new Component[0]);
            block2: for (Map.Entry<String, String> library : librariesData.entrySet()) {
                for (final JarEntry child : licensesFolder.getChildren()) {
                    if (!Objects.equals((Object)library.getKey(), (Object)child.getName())) continue;
                    String data = library.getValue();
                    int i = data.indexOf(LIBRARY_DATA_SEPARATOR);
                    String name = data.substring(0, i);
                    String url2 = data.substring(i + LIBRARY_DATA_SEPARATOR.length());
                    WebLabel nameLabel = new WebLabel(name);
                    nameLabel.setBoldFont();
                    WebLabel licenseLabel = new WebLabel("weblaf.about.dialog.libraries.license");
                    WebLink licenseLink = new WebLink(new AbstractLinkAction(child.getName()){

                        @Override
                        public void linkExecuted(@NotNull ActionEvent event) {
                            String license = FileUtils.readToString(child.getInputStream());
                            final WebDialog licenseDialog = new WebDialog((Frame)AboutLibraryDialog.this, child.getName());
                            WebTextArea textArea = new WebTextArea(StyleId.textareaNonOpaque, license);
                            textArea.setEditable(false);
                            textArea.onKeyPress(Hotkey.ESCAPE, new KeyEventRunnable(){

                                @Override
                                public void run(@NotNull KeyEvent e) {
                                    licenseDialog.dispose();
                                }
                            });
                            licenseDialog.add(new WebScrollPane(StyleId.scrollpaneTransparentHovering, textArea));
                            licenseDialog.setSize(800, 600);
                            licenseDialog.setLocationRelativeTo(AboutLibraryDialog.this);
                            licenseDialog.setVisible(true);
                        }
                    });
                    GroupPanel fileLinkPanel = new GroupPanel(5, licenseLabel, licenseLink);
                    WebLabel siteLabel = new WebLabel("weblaf.about.dialog.libraries.site");
                    WebLink siteLink = new WebLink(url2, (LinkAction)new UrlLinkAction(url2));
                    GroupPanel urlLinkPanel = new GroupPanel(5, siteLabel, siteLink);
                    librariesPanel.add((Component)new GroupPanel(StyleId.of("library"), false, nameLabel, fileLinkPanel, urlLinkPanel));
                    continue block2;
                }
            }
            tab = new WebScrollPane(StyleId.of("libraries"), librariesPanel);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(AboutLibraryDialog.class).error(e.toString(), e);
        }
        if (tab == null) {
            tab = new WebLabel("weblaf.about.dialog.libraries.error", 0, new Object[0]);
        }
        return tab;
    }

    @NotNull
    private Map<String, String> parseUrls(@NotNull String librariesUrlText) {
        LinkedHashMap<String, String> librariesUrl = new LinkedHashMap<String, String>();
        StringTokenizer st = new StringTokenizer(librariesUrlText, "\n", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int i = token.indexOf(LIBRARY_DATA_SEPARATOR);
            librariesUrl.put(token.substring(0, i), token.substring(i + LIBRARY_DATA_SEPARATOR.length()));
        }
        return librariesUrl;
    }

    @NotNull
    private Component createPropertiesTab() {
        Object[][] systemPropertiesData = this.createSystemPropertiesData();
        String key = LM.get("weblaf.about.dialog.properties.key", new Object[0]);
        String value = LM.get("weblaf.about.dialog.properties.value", new Object[0]);
        Object[] colums = new String[]{key, value};
        DefaultTableModel model = new DefaultTableModel(systemPropertiesData, colums);
        WebTable propertiesTable = new WebTable(StyleId.tableTransparent, model);
        propertiesTable.setPreferredScrollableViewportSize(new Dimension(1, 1));
        propertiesTable.setEditable(false);
        return new WebScrollPane(StyleId.scrollpaneTransparentHovering, propertiesTable);
    }

    @NotNull
    private Object[][] createSystemPropertiesData() {
        Properties properties = System.getProperties();
        Object[][] data = new Object[properties.size()][2];
        int i = 0;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        Arrays.sort(data, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return ((String)o1[0]).compareTo((String)o2[0]);
            }
        });
        return data;
    }

    public static void main(String[] args) {
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebLookAndFeel.setForceSingleEventsThread(true);
                WebLookAndFeel.install();
                StyleManager.addExtensions(new AboutLibraryExtension());
                AboutLibraryDialog dialog = new AboutLibraryDialog();
                dialog.setVisible(true);
            }
        });
    }
}

