/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.utils.FileUtils;
import java.io.File;

public enum FileSelectionMode {
    filesOnly(0),
    directoriesOnly(1),
    filesAndDirectories(2);

    private final int modeId;

    private FileSelectionMode(int modeId) {
        this.modeId = modeId;
    }

    public int getModeId() {
        return this.modeId;
    }

    public boolean accept(File file) {
        switch (this) {
            case filesOnly: {
                return !file.exists() || FileUtils.isFile(file);
            }
            case directoriesOnly: {
                return !file.exists() || FileUtils.isDirectory(file);
            }
        }
        return true;
    }

    public static FileSelectionMode get(int modeId) {
        for (FileSelectionMode mode : FileSelectionMode.values()) {
            if (mode.getModeId() != modeId) continue;
            return mode;
        }
        return null;
    }
}

