/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.WebUI;
import com.alee.laf.desktoppane.InternalFrameInputListener;
import com.alee.laf.desktoppane.InternalFrameLayout;
import com.alee.laf.desktoppane.WInternalFrameInputListener;
import com.alee.laf.desktoppane.WebInternalFrameTitlePane;
import com.alee.utils.LafUtils;
import com.alee.utils.ProprietaryUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;

public class WInternalFrameUI<C extends JInternalFrame>
extends InternalFrameUI
implements WebUI<C> {
    protected static DesktopManager sharedDesktopManager;
    protected InternalFrameInputListener<C> inputListener;
    protected C internalFrame;
    protected Component northPane;
    protected Component southPane;
    protected Component westPane;
    protected Component eastPane;

    public WInternalFrameUI() {
        ProprietaryUtils.installAWTEventListener();
    }

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "InternalFrame.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.internalFrame = (JInternalFrame)c;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.internalFrame = null;
    }

    protected void installDefaults() {
        LafUtils.installDefaults(this.internalFrame, this.getPropertyPrefix());
        ((JInternalFrame)this.internalFrame).setLayout(this.createLayoutManager());
        Icon frameIcon = ((JInternalFrame)this.internalFrame).getFrameIcon();
        if (frameIcon == null || frameIcon instanceof UIResource) {
            ((JInternalFrame)this.internalFrame).setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        }
    }

    protected void uninstallDefaults() {
        Icon frameIcon = ((JInternalFrame)this.internalFrame).getFrameIcon();
        if (frameIcon instanceof UIResource) {
            ((JInternalFrame)this.internalFrame).setFrameIcon(null);
        }
        ((JInternalFrame)this.internalFrame).setLayout(null);
        Cursor s = ((JInternalFrame)this.internalFrame).getLastCursor();
        if (s == null) {
            s = Cursor.getPredefinedCursor(0);
        }
        ((JInternalFrame)this.internalFrame).setCursor(s);
        LafUtils.uninstallDefaults(this.internalFrame);
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout();
    }

    protected void installComponents() {
        this.northPane = this.createNorthPane();
        if (this.northPane != null) {
            ((Container)this.internalFrame).add(this.northPane, "north");
            this.inputListener.installPane(this.northPane);
        }
        this.southPane = this.createSouthPane();
        if (this.southPane != null) {
            ((Container)this.internalFrame).add(this.southPane, "south");
            this.inputListener.installPane(this.southPane);
        }
        this.westPane = this.createWestPane();
        if (this.westPane != null) {
            ((Container)this.internalFrame).add(this.westPane, "west");
            this.inputListener.installPane(this.westPane);
        }
        this.eastPane = this.createEastPane();
        if (this.eastPane != null) {
            ((Container)this.internalFrame).add(this.eastPane, "east");
            this.inputListener.installPane(this.eastPane);
        }
    }

    protected void uninstallComponents() {
        if (this.northPane != null) {
            this.inputListener.uninstallPane(this.northPane);
            ((JInternalFrame)this.internalFrame).remove(this.northPane);
        }
        if (this.southPane != null) {
            this.inputListener.uninstallPane(this.southPane);
            ((JInternalFrame)this.internalFrame).remove(this.southPane);
        }
        if (this.westPane != null) {
            this.inputListener.uninstallPane(this.westPane);
            ((JInternalFrame)this.internalFrame).remove(this.westPane);
        }
        if (this.eastPane != null) {
            this.inputListener.uninstallPane(this.eastPane);
            ((JInternalFrame)this.internalFrame).remove(this.eastPane);
        }
    }

    @Nullable
    protected Component createNorthPane() {
        return new WebInternalFrameTitlePane((JComponent)this.internalFrame, (JInternalFrame)this.internalFrame);
    }

    @Nullable
    protected Component createSouthPane() {
        return null;
    }

    @Nullable
    protected Component createWestPane() {
        return null;
    }

    @Nullable
    protected Component createEastPane() {
        return null;
    }

    @Nullable
    public Component getNorthPane() {
        return this.northPane;
    }

    @Nullable
    public Component getSouthPane() {
        return this.southPane;
    }

    @Nullable
    public Component getWestPane() {
        return this.westPane;
    }

    @Nullable
    public Component getEastPane() {
        return this.eastPane;
    }

    protected void installListeners() {
        this.inputListener = this.createInternalFrameInputListener();
        this.inputListener.install(this.internalFrame);
    }

    protected void uninstallListeners() {
        this.inputListener.uninstall(this.internalFrame);
        this.inputListener = null;
    }

    protected InternalFrameInputListener<C> createInternalFrameInputListener() {
        return new WInternalFrameInputListener();
    }

    public DesktopManager getDesktopManager() {
        DesktopManager desktopManager;
        if (((JInternalFrame)this.internalFrame).getDesktopPane() != null && ((JInternalFrame)this.internalFrame).getDesktopPane().getDesktopManager() != null) {
            desktopManager = ((JInternalFrame)this.internalFrame).getDesktopPane().getDesktopManager();
        } else {
            if (sharedDesktopManager == null) {
                sharedDesktopManager = this.createDesktopManager();
            }
            desktopManager = sharedDesktopManager;
        }
        return desktopManager;
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    public void closeFrame() {
        WebLookAndFeel.playSound(this.internalFrame, "InternalFrame.closeSound");
        this.getDesktopManager().closeFrame((JInternalFrame)this.internalFrame);
    }

    public void maximizeFrame() {
        WebLookAndFeel.playSound(this.internalFrame, "InternalFrame.maximizeSound");
        this.getDesktopManager().maximizeFrame((JInternalFrame)this.internalFrame);
    }

    public void minimizeFrame() {
        if (!((JInternalFrame)this.internalFrame).isIcon()) {
            WebLookAndFeel.playSound(this.internalFrame, "InternalFrame.restoreDownSound");
        }
        this.getDesktopManager().minimizeFrame((JInternalFrame)this.internalFrame);
    }

    public void iconifyFrame() {
        WebLookAndFeel.playSound(this.internalFrame, "InternalFrame.minimizeSound");
        this.getDesktopManager().iconifyFrame((JInternalFrame)this.internalFrame);
    }

    public void deiconifyFrame() {
        if (!((JInternalFrame)this.internalFrame).isMaximum()) {
            WebLookAndFeel.playSound(this.internalFrame, "InternalFrame.restoreUpSound");
        }
        this.getDesktopManager().deiconifyFrame((JInternalFrame)this.internalFrame);
    }

    public void activateFrame() {
        this.getDesktopManager().activateFrame((JInternalFrame)this.internalFrame);
    }

    public void deactivateFrame() {
        this.getDesktopManager().deactivateFrame((JInternalFrame)this.internalFrame);
    }
}

