/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.api.annotations.NotNull;
import com.alee.laf.WebUI;
import com.alee.laf.desktoppane.DesktopIconInputListener;
import com.alee.laf.desktoppane.WDesktopIconInputListener;
import com.alee.laf.desktoppane.WebInternalFrameTitlePane;
import com.alee.utils.LafUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.plaf.DesktopIconUI;

public abstract class WDesktopIconUI<C extends JInternalFrame.JDesktopIcon>
extends DesktopIconUI
implements WebUI<C> {
    protected DesktopIconInputListener<C> inputListener;
    protected C desktopIcon;
    protected JInternalFrame internalFrame;
    protected JComponent iconPane;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "Desktop.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.desktopIcon = (JInternalFrame.JDesktopIcon)c;
        this.internalFrame = ((JInternalFrame.JDesktopIcon)this.desktopIcon).getInternalFrame();
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.internalFrame = null;
        this.desktopIcon = null;
    }

    protected void installDefaults() {
        DesktopManager desktopManager;
        JDesktopPane desktop;
        LafUtils.installDefaults(this.desktopIcon, this.getPropertyPrefix());
        if (this.internalFrame.isIcon() && this.internalFrame.getParent() == null && (desktop = ((JInternalFrame.JDesktopIcon)this.desktopIcon).getDesktopPane()) != null && (desktopManager = desktop.getDesktopManager()) instanceof DefaultDesktopManager) {
            desktopManager.iconifyFrame(this.internalFrame);
        }
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.internalFrame));
    }

    protected void uninstallDefaults() {
        DesktopManager desktopManager;
        JDesktopPane desktop;
        if (this.internalFrame.isIcon() && (desktop = ((JInternalFrame.JDesktopIcon)this.desktopIcon).getDesktopPane()) != null && (desktopManager = desktop.getDesktopManager()) instanceof DefaultDesktopManager) {
            this.internalFrame.putClientProperty("wasIconOnce", null);
            ((Component)this.desktopIcon).setLocation(Integer.MIN_VALUE, 0);
        }
        LafUtils.uninstallDefaults(this.desktopIcon);
    }

    protected void installComponents() {
        this.iconPane = new WebInternalFrameTitlePane((JComponent)this.desktopIcon, this.internalFrame);
        ((Container)this.desktopIcon).setLayout(new BorderLayout());
        ((Container)this.desktopIcon).add((Component)this.iconPane, "Center");
        if (this.iconPane instanceof WebInternalFrameTitlePane) {
            ((WebInternalFrameTitlePane)this.iconPane).install();
        }
    }

    protected void uninstallComponents() {
        if (this.iconPane instanceof WebInternalFrameTitlePane) {
            ((WebInternalFrameTitlePane)this.iconPane).uninstall();
        }
        ((Container)this.desktopIcon).remove(this.iconPane);
        ((Container)this.desktopIcon).setLayout(null);
        this.iconPane = null;
    }

    protected void installListeners() {
        this.inputListener = this.createDesktopIconInputListener();
        this.inputListener.install(this.desktopIcon);
    }

    protected void uninstallListeners() {
        this.inputListener.uninstall(this.desktopIcon);
        this.inputListener = null;
    }

    protected DesktopIconInputListener<C> createDesktopIconInputListener() {
        return new WDesktopIconInputListener();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.iconPane.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.iconPane.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.iconPane.getMaximumSize();
    }
}

