/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;

public class InternalFrameLayout
extends AbstractLayoutManager {
    protected static final String NORTH_PANE = "north";
    protected static final String SOUTH_PANE = "south";
    protected static final String WEST_PANE = "west";
    protected static final String EAST_PANE = "east";
    protected Component northPane;
    protected Component southPane;
    protected Component westPane;
    protected Component eastPane;

    @Override
    public void addComponent(@NotNull Component component2, @Nullable Object constraints) {
        if (Objects.equals(constraints, (Object)NORTH_PANE)) {
            this.northPane = component2;
        } else if (Objects.equals(constraints, (Object)SOUTH_PANE)) {
            this.southPane = component2;
        } else if (Objects.equals(constraints, (Object)WEST_PANE)) {
            this.westPane = component2;
        } else if (Objects.equals(constraints, (Object)EAST_PANE)) {
            this.eastPane = component2;
        } else {
            throw new IllegalArgumentException("Unknown constraints provided: " + constraints);
        }
    }

    @Override
    public void removeComponent(@NotNull Component component2) {
        if (component2 == this.northPane) {
            this.northPane = null;
        } else if (component2 == this.southPane) {
            this.southPane = null;
        } else if (component2 == this.westPane) {
            this.westPane = null;
        } else if (component2 == this.eastPane) {
            this.eastPane = null;
        }
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        JRootPane rootPane;
        JInternalFrame frame = (JInternalFrame)container;
        Insets insets = frame.getInsets();
        int cx = insets.left;
        int cy = insets.top;
        int cw = frame.getWidth() - insets.left - insets.right;
        int ch = frame.getHeight() - insets.top - insets.bottom;
        if (this.northPane != null) {
            Dimension northSize = this.northPane.getPreferredSize();
            this.northPane.setBounds(cx, cy, cw, northSize.height);
            cy += northSize.height;
            ch -= northSize.height;
        }
        if (this.southPane != null) {
            Dimension southSize = this.southPane.getPreferredSize();
            this.southPane.setBounds(cx, frame.getHeight() - insets.bottom - southSize.height, cw, southSize.height);
            ch -= southSize.height;
        }
        if (this.westPane != null) {
            Dimension westSize = this.westPane.getPreferredSize();
            this.westPane.setBounds(cx, cy, westSize.width, ch);
            cw -= westSize.width;
            cx += westSize.width;
        }
        if (this.eastPane != null) {
            Dimension eastSize = this.eastPane.getPreferredSize();
            this.eastPane.setBounds(cw - eastSize.width, cy, eastSize.width, ch);
            cw -= eastSize.width;
        }
        if ((rootPane = frame.getRootPane()) != null) {
            rootPane.setBounds(cx, cy, cw, ch);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        JInternalFrame frame = (JInternalFrame)container;
        Dimension ps = new Dimension(frame.getRootPane().getPreferredSize());
        Insets insets = frame.getInsets();
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        if (this.northPane != null) {
            Dimension north = this.northPane.getPreferredSize();
            ps.width = Math.max(north.width, ps.width);
            ps.height += north.height;
        }
        if (this.southPane != null) {
            Dimension south = this.southPane.getPreferredSize();
            ps.width = Math.max(south.width, ps.width);
            ps.height += south.height;
        }
        if (this.eastPane != null) {
            Dimension east = this.eastPane.getPreferredSize();
            ps.width += east.width;
            ps.height = Math.max(east.height, ps.height);
        }
        if (this.westPane != null) {
            Dimension west = this.westPane.getPreferredSize();
            ps.width += west.width;
            ps.height = Math.max(west.height, ps.height);
        }
        return ps;
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        JInternalFrame frame = (JInternalFrame)container;
        Dimension ms = this.northPane != null ? this.northPane.getMinimumSize() : new Dimension();
        Insets insets = frame.getInsets();
        ms.width += insets.left + insets.right;
        ms.height += insets.top + insets.bottom;
        return ms;
    }
}

