/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.extended.behavior.AbstractComponentBehavior;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComboBox;

public class ComboBoxMouseWheelScrollBehavior
extends AbstractComponentBehavior<JComboBox>
implements MouseWheelListener {
    public ComboBoxMouseWheelScrollBehavior(@NotNull JComboBox comboBox) {
        super(comboBox);
    }

    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
        int index;
        int newIndex;
        if (((JComboBox)this.component).isEnabled() && SwingUtils.hasFocusOwner(this.component) && (newIndex = MathUtils.limit(0, (index = ((JComboBox)this.component).getSelectedIndex()) + e.getWheelRotation(), ((JComboBox)this.component).getModel().getSize() - 1)) != index) {
            ((JComboBox)this.component).setSelectedIndex(newIndex);
        }
    }

    @NotNull
    public static ComboBoxMouseWheelScrollBehavior install(@NotNull JComboBox comboBox) {
        ComboBoxMouseWheelScrollBehavior.uninstall(comboBox);
        ComboBoxMouseWheelScrollBehavior behavior = new ComboBoxMouseWheelScrollBehavior(comboBox);
        comboBox.addMouseWheelListener(behavior);
        return behavior;
    }

    public static void uninstall(@NotNull JComboBox comboBox) {
        for (MouseWheelListener listener : comboBox.getMouseWheelListeners()) {
            if (!(listener instanceof ComboBoxMouseWheelScrollBehavior)) continue;
            comboBox.removeMouseWheelListener(listener);
        }
    }

    public static boolean isInstalled(@NotNull JComboBox comboBox) {
        for (MouseWheelListener listener : comboBox.getMouseWheelListeners()) {
            if (!(listener instanceof ComboBoxMouseWheelScrollBehavior)) continue;
            return true;
        }
        return false;
    }
}

