/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.api.annotations.NotNull;
import com.alee.utils.ColorUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;

public class PaletteColorChooserPaint
implements Paint {
    private Color cornerColor;
    private boolean webSafe = false;
    private ColorModel model = ColorModel.getRGBdefault();
    private int x;
    private int y;
    private int width;
    private int height;

    public PaletteColorChooserPaint(int x, int y, int width, int height, @NotNull Color cornerColor) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.cornerColor = cornerColor;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, final AffineTransform xform, RenderingHints hints) {
        return new PaintContext(){
            private Map<Rectangle, WritableRaster> rastersCache = new HashMap<Rectangle, WritableRaster>();

            @Override
            public void dispose() {
                this.rastersCache.clear();
            }

            @Override
            public ColorModel getColorModel() {
                return PaletteColorChooserPaint.this.model;
            }

            @Override
            public Raster getRaster(int x, int y, int w, int h) {
                Rectangle r = new Rectangle(x, y, w, h);
                if (this.rastersCache.containsKey(r)) {
                    return this.rastersCache.get(r);
                }
                WritableRaster raster = PaletteColorChooserPaint.this.model.createCompatibleWritableRaster(w, h);
                x = (int)((long)x - Math.round(xform.getTranslateX()));
                y = (int)((long)y - Math.round(xform.getTranslateY()));
                int[] data = new int[w * h * 4];
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        int base = (j * w + i) * 4;
                        data[base] = PaletteColorChooserPaint.this.getRed(x + i, y + j);
                        data[base + 1] = PaletteColorChooserPaint.this.getGreen(x + i, y + j);
                        data[base + 2] = PaletteColorChooserPaint.this.getBlue(x + i, y + j);
                        data[base + 3] = 255;
                    }
                }
                raster.setPixels(0, 0, w, h, data);
                this.rastersCache.put(r, raster);
                return raster;
            }
        };
    }

    public Color getColor(int xCoord, int yCoord) {
        if (xCoord < this.x) {
            xCoord = this.x;
        } else if (xCoord > this.x + 256) {
            xCoord = this.x + 256;
        }
        if (yCoord < this.y) {
            yCoord = this.y;
        } else if (yCoord > this.y + 256) {
            yCoord = this.y + 256;
        }
        return new Color(this.getRed(xCoord, yCoord), this.getGreen(xCoord, yCoord), this.getBlue(xCoord, yCoord));
    }

    private int getRed(int xCoord, int yCoord) {
        int red = 255 - (255 - this.cornerColor.getRed()) * (xCoord - this.x) / this.width;
        red -= red * (yCoord - this.y) / this.height;
        return this.getWebSafe(red);
    }

    private int getGreen(int xCoord, int yCoord) {
        int green = 255 - (255 - this.cornerColor.getGreen()) * (xCoord - this.x) / this.width;
        green -= green * (yCoord - this.y) / this.height;
        return this.getWebSafe(green);
    }

    private int getBlue(int xCoord, int yCoord) {
        int blue = 255 - (255 - this.cornerColor.getBlue()) * (xCoord - this.x) / this.width;
        blue -= blue * (yCoord - this.y) / this.height;
        return this.getWebSafe(blue);
    }

    private int getWebSafe(int color) {
        if (this.webSafe) {
            color = ColorUtils.webSafe(color);
        }
        if (color < 0) {
            color = 0;
        } else if (color > 255) {
            color = 255;
        }
        return color;
    }

    @Override
    public int getTransparency() {
        return 1;
    }

    public Color getCornerColor() {
        return this.cornerColor;
    }

    public boolean isWebSafe() {
        return this.webSafe;
    }

    public void setWebSafe(boolean webSafe) {
        this.webSafe = webSafe;
    }
}

