/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.button.ButtonState;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;

public class ButtonSettingsProcessor
extends SettingsProcessor<AbstractButton, ButtonState, Configuration<ButtonState>> {
    protected transient ItemListener itemListener;

    public ButtonSettingsProcessor(AbstractButton button, Configuration configuration) {
        super(button, configuration);
    }

    @Override
    protected void register(@NotNull AbstractButton button) {
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ButtonSettingsProcessor.this.save();
            }
        };
        button.addItemListener(this.itemListener);
    }

    @Override
    public void unregister(@NotNull AbstractButton button) {
        button.removeItemListener(this.itemListener);
        this.itemListener = null;
    }

    @Override
    @Nullable
    protected ButtonState createDefaultValue() {
        return new ButtonState((AbstractButton)this.component());
    }

    @Override
    public void loadSettings(@NotNull AbstractButton button) {
        ((ButtonState)this.loadSettings()).apply(button);
    }

    @Override
    public void saveSettings(@NotNull AbstractButton button) {
        this.saveSettings(new ButtonState(button));
    }
}

