/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractIconContent;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;

@XStreamAlias(value="ButtonIcon")
public class ButtonIcon<C extends AbstractButton, D extends IDecoration<C, D>, I extends ButtonIcon<C, D, I>>
extends AbstractIconContent<C, D, I> {
    @Override
    @Nullable
    protected Icon getIcon(@NotNull C c, @NotNull D d) {
        Icon icon = ((AbstractButton)c).getIcon();
        if (icon != null) {
            ButtonModel model = ((AbstractButton)c).getModel();
            Icon tmpIcon = null;
            Icon selectedIcon = null;
            if (model.isSelected() && (selectedIcon = ((AbstractButton)c).getSelectedIcon()) != null) {
                icon = selectedIcon;
            }
            if (!model.isEnabled()) {
                if (model.isSelected() && (tmpIcon = ((AbstractButton)c).getDisabledSelectedIcon()) == null) {
                    tmpIcon = selectedIcon;
                }
                if (tmpIcon == null) {
                    tmpIcon = ((AbstractButton)c).getDisabledIcon();
                }
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = ((AbstractButton)c).getPressedIcon();
            } else if (((AbstractButton)c).isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected() && (tmpIcon = ((AbstractButton)c).getRolloverSelectedIcon()) == null) {
                    tmpIcon = selectedIcon;
                }
                if (tmpIcon == null) {
                    tmpIcon = ((AbstractButton)c).getRolloverIcon();
                }
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        return icon;
    }
}

