/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.laf.AltProcessor;
import com.alee.laf.ControlType;
import com.alee.laf.LookAndFeelException;
import com.alee.laf.NativeFonts;
import com.alee.laf.StrictEventThreadListeners;
import com.alee.laf.VisibleWindowListener;
import com.alee.laf.WebLayoutStyle;
import com.alee.laf.edt.ExceptionNonEventThreadHandler;
import com.alee.laf.edt.NonEventThreadHandler;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.managers.animation.AnimationManager;
import com.alee.managers.drag.DragManager;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hover.HoverManager;
import com.alee.managers.icon.IconManager;
import com.alee.managers.icon.Icons;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.proxy.UIProxyManager;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleManager;
import com.alee.managers.task.TaskManager;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.skin.light.WebLightSkin;
import com.alee.utils.ColorUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.laf.WebBorder;
import com.alee.utils.reflection.LazyInstance;
import com.alee.utils.swing.SwingLazyValue;
import com.alee.utils.swing.WeakComponentDataOrderedSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class WebLookAndFeel
extends BasicLookAndFeel {
    public static final String PROPERTY_HONOR_USER_BORDER = "WebLookAndFeel.honorUserBorder";
    public static final String PROPERTY_HONOR_USER_BORDERS = "WebLookAndFeel.honorUserBorders";
    public static final String LOOK_AND_FEEL_PROPERTY = "lookAndFeel";
    public static final String UI_PROPERTY = "UI";
    public static final String LAF_MARGIN_PROPERTY = "lafMargin";
    public static final String LAF_PADDING_PROPERTY = "lafPadding";
    public static final String COMPONENT_ORIENTATION_PROPERTY = "componentOrientation";
    public static final String ANCESTOR_PROPERTY = "ancestor";
    public static final String MARGIN_PROPERTY = "margin";
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String FOCUSABLE_PROPERTY = "focusable";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String MODEL_PROPERTY = "model";
    public static final String VISIBLE_PROPERTY = "visible";
    public static final String DOCUMENT_PROPERTY = "document";
    public static final String OPAQUE_PROPERTY = "opaque";
    public static final String BORDER_PROPERTY = "border";
    public static final String ICON_TEXT_GAP_PROPERTY = "iconTextGap";
    public static final String PAINTER_PROPERTY = "painter";
    public static final String TEXT_PROPERTY = "text";
    public static final String TIP_TEXT_PROPERTY = "tiptext";
    public static final String FONT_PROPERTY = "font";
    public static final String BACKGROUND_PROPERTY = "background";
    public static final String FOREGROUND_PROPERTY = "foreground";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String LEADING_COMPONENT_PROPERTY = "leadingComponent";
    public static final String TRAILING_COMPONENT_PROPERTY = "trailingComponent";
    protected static boolean installed = false;
    protected static boolean forceSingleEventsThread = false;
    protected static boolean useStrictEventThreadListeners = false;
    @NotNull
    protected static final StrictEventThreadListeners STRICT_EDT_LISTENERS = new StrictEventThreadListeners();
    @NotNull
    protected static NonEventThreadHandler nonEventThreadHandler = new ExceptionNonEventThreadHandler();
    @Nullable
    protected static List<ImageIcon> icons = null;
    @NotNull
    protected static final AltProcessor altProcessor = new AltProcessor();
    protected static boolean isMnemonicHidden = true;
    protected static boolean shapeDetectionEnabled = true;
    @NotNull
    protected static final EventListenerList globalListeners = new EventListenerList();
    @NotNull
    protected static final WeakComponentDataOrderedSet<JComponent, VisibleWindowListener> visibleWindowListeners = new WeakComponentDataOrderedSet("WebLookAndFeel.VisibleWindowListener", 50);
    protected static Class<? extends LookAndFeel> previousLookAndFeelClass;
    protected static ComponentOrientation orientation;
    public static Font globalControlFont;
    public static Font canvasFont;
    public static Font imageFont;
    public static Font buttonFont;
    public static Font splitButtonFont;
    public static Font toggleButtonFont;
    public static Font checkBoxFont;
    public static Font tristateCheckBoxFont;
    public static Font radioButtonFont;
    public static Font comboBoxFont;
    public static Font spinnerFont;
    public static Font textFieldFont;
    public static Font formattedTextFieldFont;
    public static Font passwordFieldFont;
    public static Font colorChooserFont;
    public static Font fileChooserFont;
    public static Font labelFont;
    public static Font styledLabelFont;
    public static Font linkFont;
    public static Font listFont;
    public static Font panelFont;
    public static Font overlayFont;
    public static Font popupFont;
    public static Font progressBarFont;
    public static Font scrollPaneFont;
    public static Font viewportFont;
    public static Font sliderFont;
    public static Font tabbedPaneFont;
    public static Font tableFont;
    public static Font tableHeaderFont;
    public static Font titledBorderFont;
    public static Font treeFont;
    public static Font memoryBarFont;
    public static Font globalTextFont;
    public static Font textAreaFont;
    public static Font textPaneFont;
    public static Font editorPaneFont;
    public static Font globalTooltipFont;
    public static Font toolTipFont;
    public static Font globalMenuFont;
    public static Font menuBarFont;
    public static Font menuFont;
    public static Font menuItemFont;
    public static Font radioButtonMenuItemFont;
    public static Font checkBoxMenuItemFont;
    public static Font popupMenuFont;
    public static Font toolBarFont;
    public static Font globalMenuSmallFont;
    public static Font menuAcceleratorFont;
    public static Font menuItemAcceleratorFont;
    public static Font radioButtonMenuItemAcceleratorFont;
    public static Font checkBoxMenuItemAcceleratorFont;
    public static Font globalWindowFont;
    public static Font internalFrameFont;
    public static Font globalMessageFont;
    public static Font optionPaneFont;

    @Override
    public String getName() {
        return "WebLaF";
    }

    @Override
    public String getID() {
        return "weblaf";
    }

    @Override
    public String getDescription() {
        return "Styleable cross-platform Look and Feel for Swing applications";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    public void initialize() {
        WebLookAndFeel.initializeManagers();
        super.initialize();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(altProcessor);
        installed = true;
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(altProcessor);
        installed = false;
    }

    @Override
    protected void initClassDefaults(@NotNull UIDefaults table2) {
        for (ComponentDescriptor descriptor : StyleManager.getDescriptors()) {
            descriptor.updateDefaults(table2);
        }
    }

    @Override
    protected void initSystemColorDefaults(@NotNull UIDefaults table2) {
        super.initSystemColorDefaults(table2);
        String menuColor = ColorUtils.toHex(Color.WHITE);
        String textColor = ColorUtils.toHex(Color.BLACK);
        String textHighlightColor = ColorUtils.toHex(new Color(210, 210, 210));
        String inactiveTextColor = ColorUtils.toHex(new Color(160, 160, 160));
        String[] defaultSystemColors = new String[]{"menu", menuColor, "menuText", textColor, "textHighlight", textHighlightColor, "textHighlightText", textColor, "textInactiveText", inactiveTextColor, "controlText", textColor};
        this.loadSystemColors(table2, defaultSystemColors, this.isNativeLookAndFeel());
    }

    @Override
    protected void initComponentDefaults(@NotNull UIDefaults table2) {
        super.initComponentDefaults(table2);
        ProprietaryUtils.setupAATextInfo(table2);
        WebLookAndFeel.initializeFonts(table2);
        table2.put("MenuBar.windowBindings", new Object[]{"F10", "takeFocus"});
        table2.put("Button.border", (Object)null);
        table2.put("Button.showMnemonics", Boolean.TRUE);
        table2.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
        table2.put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}));
        table2.put("ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}));
        table2.put("SplitButton.defaultButtonFollowsFocus", Boolean.FALSE);
        table2.put("SplitButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}));
        table2.put("CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}));
        table2.put("RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed"}));
        table2.put("TristateCheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}));
        table2.put("ProgressBar.border", (Object)null);
        table2.put("SplitPane.dividerSize", (Object)2);
        table2.put("SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}));
        table2.put("OptionPane.isYesLast", SystemUtils.isMac() ? Boolean.TRUE : Boolean.FALSE);
        table2.put("html.pendingImage", Icons.hourglass);
        table2.put("html.missingImage", Icons.broken);
        table2.put("Tree.closedIcon", Icons.folder);
        table2.put("Tree.openIcon", Icons.folderOpen);
        table2.put("Tree.leafIcon", Icons.leaf);
        table2.put("Tree.collapsedIcon", Icons.squarePlus);
        table2.put("Tree.expandedIcon", Icons.squareMinus);
        table2.put("Tree.textForeground", new ColorUIResource(Color.BLACK));
        table2.put("Tree.textBackground", new ColorUIResource(new Color(255, 255, 255, 0)));
        table2.put("Tree.selectionForeground", new ColorUIResource(Color.BLACK));
        table2.put("Tree.selectionBackground", new ColorUIResource(new Color(255, 255, 255, 0)));
        table2.put("Tree.selectionBorderColor", new ColorUIResource(new Color(255, 255, 255, 0)));
        table2.put("Tree.dropCellBackground", new ColorUIResource(new Color(255, 255, 255, 0)));
        table2.put("Tree.rendererFillBackground", Boolean.FALSE);
        table2.put("Tree.drawsFocusBorderAroundIcon", Boolean.FALSE);
        table2.put("Tree.drawDashedFocusIndicator", Boolean.FALSE);
        table2.put("Tree.leftChildIndent", (Object)12);
        table2.put("Tree.rightChildIndent", (Object)12);
        table2.put("Tree.lineTypeDashed", Boolean.TRUE);
        table2.put("Menu.menuPopupOffsetX", (Object)0);
        table2.put("Menu.menuPopupOffsetY", (Object)0);
        table2.put("Menu.submenuPopupOffsetX", (Object)0);
        table2.put("Menu.submenuPopupOffsetY", (Object)0);
        table2.put("OptionPane.buttonClickThreshold", (Object)500);
        table2.put("Table.cellNoFocusBorder", new WebBorder(1, 1, 1, 1));
        table2.put("Table.focusSelectedCellHighlightBorder", new WebBorder(1, 1, 1, 1));
        table2.put("Table.focusCellHighlightBorder", new WebBorder(1, 1, 1, 1));
        table2.put("Table.scrollPaneBorder", (Object)null);
        table2.put("TableHeader.cellBorder", new WebBorder(0, 10, 1, 10));
        table2.put("TableHeader.focusCellBorder", new WebBorder(0, 10, 1, 10));
        table2.put("List.cellRenderer", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table2) {
                return new WebListCellRenderer.UIResource();
            }
        });
        table2.put("ComboBox.selectionForeground", new ColorUIResource(Color.BLACK));
        table2.put("ComboBox.squareButton", (Object)false);
        table2.put("ComboBox.padding", (Object)null);
        table2.put("MemoryBar.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}));
        table2.put("TextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "HOME", "caret-begin", "END", "caret-end", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"}));
        table2.put("PasswordField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-begin-line", "control RIGHT", "caret-end-line", "control shift LEFT", "selection-begin-line", "control shift RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"}));
        table2.put("FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin", "END", "caret-end", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}));
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control A", "select-all", "control BACK_SLASH", "unselect", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "UP", "caret-up", "DOWN", "caret-down", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        table2.put("TextArea.focusInputMap", multilineInputMap);
        table2.put("TextPane.focusInputMap", multilineInputMap);
        table2.put("EditorPane.focusInputMap", multilineInputMap);
        table2.put("Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "ctrl PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "ctrl PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}));
        table2.put("ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}));
        table2.put("TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"}));
        table2.put("TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"alt LEFT", "navigateLeft", "alt KP_LEFT", "navigateLeft", "alt RIGHT", "navigateRight", "alt KP_RIGHT", "navigateRight", "ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus", "ctrl F", "scrollTabsForwardAction", "ctrl B", "scrollTabsBackwardAction"}));
        table2.put("FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up", "ENTER", "approveSelection", "ctrl ENTER", "approveSelection"}));
        table2.put("Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "shift RIGHT", "shrinkRight", "shift KP_RIGHT", "shrinkRight", "LEFT", "left", "KP_LEFT", "left", "shift LEFT", "shrinkLeft", "shift KP_LEFT", "shrinkLeft", "UP", "up", "KP_UP", "up", "shift UP", "shrinkUp", "shift KP_UP", "shrinkUp", "DOWN", "down", "KP_DOWN", "down", "shift DOWN", "shrinkDown", "shift KP_DOWN", "shrinkDown", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame", "ctrl F12", "navigateNext", "shift ctrl F12", "navigatePrevious"}));
    }

    protected static void initializeFonts(@NotNull UIDefaults table2) {
        WebLookAndFeel.initializeFont(table2, "Canvas.font", canvasFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Image.font", imageFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Button.font", buttonFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "SplitButton.font", splitButtonFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "ToggleButton.font", toggleButtonFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "CheckBox.font", checkBoxFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "TristateCheckBox.font", tristateCheckBoxFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "RadioButton.font", radioButtonFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "ComboBox.font", comboBoxFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Spinner.font", spinnerFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "TextField.font", textFieldFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "FormattedTextField.font", formattedTextFieldFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "PasswordField.font", passwordFieldFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "ColorChooser.font", colorChooserFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "FileChooser.font", fileChooserFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Label.font", labelFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "StyledLabel.font", styledLabelFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Link.font", linkFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "List.font", listFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Panel.font", panelFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Overlay.font", overlayFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Popup.font", popupFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "ProgressBar.font", progressBarFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "ScrollPane.font", scrollPaneFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Viewport.font", viewportFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Slider.font", sliderFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "TabbedPane.font", tabbedPaneFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Table.font", tableFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "TableHeader.font", tableHeaderFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "TitledBorder.font", titledBorderFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "Tree.font", treeFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "MemoryBar.font", memoryBarFont, globalControlFont);
        WebLookAndFeel.initializeFont(table2, "TextArea.font", textAreaFont, globalTextFont);
        WebLookAndFeel.initializeFont(table2, "TextPane.font", textPaneFont, globalTextFont);
        WebLookAndFeel.initializeFont(table2, "EditorPane.font", editorPaneFont, globalTextFont);
        WebLookAndFeel.initializeFont(table2, "ToolTip.font", toolTipFont, globalTooltipFont);
        WebLookAndFeel.initializeFont(table2, "PopupMenu.font", popupMenuFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table2, "MenuBar.font", menuBarFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table2, "Menu.font", menuFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table2, "MenuItem.font", menuItemFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table2, "RadioButtonMenuItem.font", radioButtonMenuItemFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table2, "CheckBoxMenuItem.font", checkBoxMenuItemFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table2, "ToolBar.font", toolBarFont, globalMenuFont);
        WebLookAndFeel.initializeFont(table2, "Menu.acceleratorFont", menuAcceleratorFont, globalMenuSmallFont);
        WebLookAndFeel.initializeFont(table2, "MenuItem.acceleratorFont", menuItemAcceleratorFont, globalMenuSmallFont);
        WebLookAndFeel.initializeFont(table2, "RadioButtonMenuItem.acceleratorFont", radioButtonMenuItemAcceleratorFont, globalMenuSmallFont);
        WebLookAndFeel.initializeFont(table2, "CheckBoxMenuItem.acceleratorFont", checkBoxMenuItemAcceleratorFont, globalMenuSmallFont);
        WebLookAndFeel.initializeFont(table2, "InternalFrame.titleFont", internalFrameFont, globalWindowFont);
        WebLookAndFeel.initializeFont(table2, "OptionPane.font", optionPaneFont, globalMessageFont);
    }

    protected static void initializeFont(@NotNull UIDefaults table2, @NotNull String key, @Nullable Font font, @NotNull Font globalFont) {
        table2.put(key, WebLookAndFeel.createLazyFont(font != null ? font : globalFont));
    }

    @NotNull
    protected static SwingLazyValue createLazyFont(@NotNull Font font) {
        return new SwingLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{font});
    }

    public static void setMnemonicHidden(boolean hide) {
        isMnemonicHidden = !UIManager.getBoolean("Button.showMnemonics") && hide;
    }

    public static boolean isMnemonicHidden() {
        if (UIManager.getBoolean("Button.showMnemonics")) {
            isMnemonicHidden = false;
        }
        return isMnemonicHidden;
    }

    public static boolean isShapeDetectionEnabled() {
        return shapeDetectionEnabled;
    }

    public static void setShapeDetectionEnabled(boolean enabled) {
        shapeDetectionEnabled = enabled;
    }

    public static void initializeManagers() {
        WebLookAndFeel.checkEventDispatchThread();
        XmlUtils.getXStream();
        UILanguageManager.initialize();
        UISettingsManager.initialize();
        HotkeyManager.initialize();
        FocusManager.initialize();
        HoverManager.initialize();
        TooltipManager.initialize();
        IconManager.initialize();
        StyleManager.initialize();
        AnimationManager.initialize();
        UIProxyManager.initialize();
        DragManager.initialize();
        TaskManager.initialize();
    }

    public static void install() throws LookAndFeelException {
        WebLookAndFeel.install(WebLightSkin.class, new Object[0]);
    }

    public static void install(@NotNull Class<? extends Skin> skin, Object ... arguments) throws LookAndFeelException {
        WebLookAndFeel.install(new LazyInstance<Skin>(skin, arguments));
    }

    public static void install(@NotNull LazyInstance<? extends Skin> skin) throws LookAndFeelException {
        WebLookAndFeel.checkEventDispatchThread();
        previousLookAndFeelClass = UIManager.getLookAndFeel().getClass();
        StyleManager.setDefaultSkin(skin);
        LafUtils.setupLookAndFeel(WebLookAndFeel.class);
    }

    public static boolean isInstalled() {
        return installed;
    }

    public static void uninstall() throws LookAndFeelException {
        WebLookAndFeel.checkEventDispatchThread();
        if (WebLookAndFeel.isInstalled()) {
            if (previousLookAndFeelClass == null) {
                throw new LookAndFeelException("There was no previously installed LaF");
            }
        } else {
            throw new LookAndFeelException("WebLookAndFeel was not installed yet");
        }
        LafUtils.setupLookAndFeel(previousLookAndFeelClass);
        previousLookAndFeelClass = null;
    }

    public static boolean isForceSingleEventsThread() {
        return forceSingleEventsThread;
    }

    public static void setForceSingleEventsThread(boolean enforce) {
        forceSingleEventsThread = enforce;
    }

    public static boolean isUseStrictEventThreadListeners() {
        return useStrictEventThreadListeners;
    }

    public static void setUseStrictEventThreadListeners(boolean strict) {
        useStrictEventThreadListeners = strict;
    }

    @NotNull
    public static NonEventThreadHandler getNonEventThreadHandler() {
        return nonEventThreadHandler;
    }

    public static void setNonEventThreadHandler(@NotNull NonEventThreadHandler handler) {
        nonEventThreadHandler = handler;
    }

    public static void checkEventDispatchThread() {
        if (WebLookAndFeel.isForceSingleEventsThread() && !CoreSwingUtils.isEventDispatchThread()) {
            WebLookAndFeel.getNonEventThreadHandler().handle(new LookAndFeelException(String.format("This operation is only permitted on the Event Dispatch Thread. Current thread is: %s", Thread.currentThread().getName())));
        }
    }

    public static void installEventDispatchThreadCheckers(@NotNull Component component2) {
        WebLookAndFeel.checkEventDispatchThread();
        if (WebLookAndFeel.isForceSingleEventsThread() && WebLookAndFeel.isUseStrictEventThreadListeners()) {
            component2.addHierarchyListener(STRICT_EDT_LISTENERS);
            component2.addPropertyChangeListener(STRICT_EDT_LISTENERS);
            component2.addComponentListener(STRICT_EDT_LISTENERS);
            component2.addMouseListener(STRICT_EDT_LISTENERS);
            component2.addMouseWheelListener(STRICT_EDT_LISTENERS);
            component2.addMouseMotionListener(STRICT_EDT_LISTENERS);
            component2.addKeyListener(STRICT_EDT_LISTENERS);
            component2.addFocusListener(STRICT_EDT_LISTENERS);
        }
    }

    public static void uninstallEventDispatchThreadCheckers(@NotNull Component component2) {
        WebLookAndFeel.checkEventDispatchThread();
        if (WebLookAndFeel.isForceSingleEventsThread() && WebLookAndFeel.isUseStrictEventThreadListeners()) {
            component2.removeFocusListener(STRICT_EDT_LISTENERS);
            component2.removeKeyListener(STRICT_EDT_LISTENERS);
            component2.removeMouseMotionListener(STRICT_EDT_LISTENERS);
            component2.removeMouseWheelListener(STRICT_EDT_LISTENERS);
            component2.removeMouseListener(STRICT_EDT_LISTENERS);
            component2.removeComponentListener(STRICT_EDT_LISTENERS);
            component2.removePropertyChangeListener(STRICT_EDT_LISTENERS);
            component2.removeHierarchyListener(STRICT_EDT_LISTENERS);
        }
    }

    public static void playSound(JComponent component2, Object actionKey) {
        Action audioAction;
        ActionMap map;
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof WebLookAndFeel && (map = component2.getActionMap()) != null && (audioAction = map.get(actionKey)) != null) {
            ((WebLookAndFeel)laf).playSound(audioAction);
        }
    }

    @NotNull
    public static List<Image> getImages() {
        ArrayList<Image> images = new ArrayList<Image>();
        for (ImageIcon icon : WebLookAndFeel.getLookAndFeelIcons()) {
            images.add(icon.getImage());
        }
        return images;
    }

    @NotNull
    public static List<ImageIcon> getIcons() {
        ArrayList<ImageIcon> imageIcons = new ArrayList<ImageIcon>();
        imageIcons.addAll(WebLookAndFeel.getLookAndFeelIcons());
        return imageIcons;
    }

    @NotNull
    public static Image getImage(int size) {
        return WebLookAndFeel.getIcon(size).getImage();
    }

    @NotNull
    public static ImageIcon getIcon(int size) {
        ImageIcon imageIcon = null;
        for (ImageIcon icon : WebLookAndFeel.getLookAndFeelIcons()) {
            if (icon.getIconWidth() != size) continue;
            imageIcon = icon;
            break;
        }
        if (imageIcon == null) {
            throw new LookAndFeelException("Unable to load LookAndFeel icon for size: " + size);
        }
        return imageIcon;
    }

    @NotNull
    protected static List<ImageIcon> getLookAndFeelIcons() {
        if (icons == null) {
            int[] sizes = new int[]{16, 24, 32, 48, 64, 128, 256, 512};
            icons = new ArrayList<ImageIcon>(sizes.length);
            for (int size : sizes) {
                icons.add(new ImageIcon(WebLookAndFeel.class.getResource("icons/icon" + size + ".png")));
            }
        }
        return icons;
    }

    @Override
    @Nullable
    public Icon getDisabledIcon(@Nullable JComponent component2, @Nullable Icon icon) {
        Icon disabledIcon = icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0 ? ImageUtils.getDisabledCopy(icon) : icon;
        return disabledIcon;
    }

    public static void updateAllComponentUIs() {
        WebLookAndFeel.checkEventDispatchThread();
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    @Override
    @NotNull
    public LayoutStyle getLayoutStyle() {
        return WebLayoutStyle.getInstance();
    }

    public static boolean isAllowLinuxTransparency() {
        return ProprietaryUtils.isAllowLinuxTransparency();
    }

    public static void setAllowLinuxTransparency(boolean allow) {
        ProprietaryUtils.setAllowLinuxTransparency(allow);
    }

    public static boolean isLeftToRight() {
        return WebLookAndFeel.getOrientation().isLeftToRight();
    }

    public static void setLeftToRightOrientation(boolean leftToRight) {
        WebLookAndFeel.setOrientation(leftToRight ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
    }

    @NotNull
    public static ComponentOrientation getOrientation() {
        return orientation != null ? orientation : ComponentOrientation.getOrientation(Locale.getDefault());
    }

    public static void setOrientation(@NotNull ComponentOrientation orientation) {
        WebLookAndFeel.orientation = orientation;
        SwingUtils.updateGlobalOrientation(WebLookAndFeel.orientation);
    }

    public static void changeOrientation() {
        WebLookAndFeel.setLeftToRightOrientation(!WebLookAndFeel.getOrientation().isLeftToRight());
    }

    public static void updateOrientation() {
        SwingUtils.updateGlobalOrientation(orientation);
    }

    public static void setOrientation(@NotNull Component component2) {
        ComponentOrientation orientation = WebLookAndFeel.getOrientation();
        if (!(orientation.isLeftToRight() == component2.getComponentOrientation().isLeftToRight() || SystemUtils.isJava9orAbove() && component2 instanceof JSpinner.NumberEditor)) {
            component2.setComponentOrientation(orientation);
        }
    }

    public static void addVisibleWindowListener(@NotNull VisibleWindowListener listener) {
        globalListeners.add(VisibleWindowListener.class, listener);
    }

    public static void removeVisibleWindowListener(@NotNull VisibleWindowListener listener) {
        globalListeners.remove(VisibleWindowListener.class, listener);
    }

    public static void addVisibleWindowListener(@NotNull JComponent component2, @NotNull VisibleWindowListener listener) {
        visibleWindowListeners.add(component2, listener);
    }

    public static void removeVisibleWindowListener(@NotNull JComponent component2, @NotNull VisibleWindowListener listener) {
        visibleWindowListeners.remove(component2, listener);
    }

    public static void fireWindowDisplayed(final @NotNull Window window) {
        for (VisibleWindowListener listener : (VisibleWindowListener[])globalListeners.getListeners(VisibleWindowListener.class)) {
            listener.windowDisplayed(window);
        }
        visibleWindowListeners.forEachData(new BiConsumer<JComponent, VisibleWindowListener>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull VisibleWindowListener listener) {
                listener.windowDisplayed(window);
            }
        });
    }

    public static void fireWindowHidden(final @NotNull Window window) {
        for (VisibleWindowListener listener : (VisibleWindowListener[])globalListeners.getListeners(VisibleWindowListener.class)) {
            listener.windowHidden(window);
        }
        visibleWindowListeners.forEachData(new BiConsumer<JComponent, VisibleWindowListener>(){

            @Override
            public void accept(@NotNull JComponent component2, @NotNull VisibleWindowListener listener) {
                listener.windowHidden(window);
            }
        });
    }

    static {
        globalControlFont = NativeFonts.get(ControlType.CONTROL);
        globalTextFont = NativeFonts.get(ControlType.TEXT);
        globalTooltipFont = NativeFonts.get(ControlType.TOOLTIP);
        globalMenuFont = NativeFonts.get(ControlType.MENU);
        globalMenuSmallFont = NativeFonts.get(ControlType.MENU_SMALL);
        globalWindowFont = NativeFonts.get(ControlType.WINDOW);
        globalMessageFont = NativeFonts.get(ControlType.MESSAGE);
    }
}

